
/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *  Written by Steve Anderson and Toby Orloff, summer 1990.
 */

#include "omni_proc.h"

Attack_data (argv)
char **argv;
{
  char line[800];
  double *x, *y;
  long *m, *n;
  int i, j, index, linelen, ch, stop, newlines;
  struct LINE *space;

  /* The following conditional, and many like it throughout this function,
     allows processing of either integers or floats. */

  if (target != INT_NOT_FLOAT) {	/* Set array size */
    x = (double *) malloc (chunk * sizeof(double));
    y = (double *) malloc (chunk * sizeof(double));
  } else {
    m = (long *) malloc (chunk * sizeof(long));
    n = (long *) malloc (chunk * sizeof(long));
  }

  if ( type == ASCII) {
    newlines = 0;	/* Set line counter to 0 */
    space = (struct LINE *) malloc ((chunk+1) * sizeof(struct LINE));
	/* space is an array of spaces between data. */

    for (i=0; i<skip; i++) {	/* skip & copy first 'skip' lines */
      fgets (line, 100, infile);
      fprintf (outfile, "%s",line);
      newlines++;
    }

    sprintf (line, "");	/* Empty line string */
    linelen = 0;	/* linelen = length of line */
    index = 0;		/* index = # of data processed */
    stop = 0;		/* This is set at end of file */

    while ((!stop) && ((tail<0) || (newlines < tail))) {

/* Reset spaces between data */

      for (j=0; j<chunk+1; j++) {
	sprintf (space[j].c, "");
      }

/* Read in data and spaces */

      for (j=0; ((j<chunk) && (!stop));) {	/* chunk = # of data to send
						to function at once */
	switch (ch = getc(infile)) {
	  case '\n':
	  newlines ++;
	  case '\t':
	  case ' ':
	    if (line[0] != '\0') {	/* If 'line' not empty */
	      if (is_a_target(line)) {
		if (target != INT_NOT_FLOAT) x[j] = atof (line);
		else m[j] = atol (line);
		index++;	/* One more datum processed */
		j++;
	      } else {	/* Attach to space between data */
		  sprintf (space[j].c, "%s%s", space[j].c, line);
		  if (strlen(space[j].c) > 800) {
		    fprintf (outfile, "%s", space[j].c);
		    sprintf (space[j].c, "");
		  }
		}
	    }
	    linelen = 0;	/* Reset line */
	    line[0] = '\0';
	    sprintf (space[j].c, "%s%c", space[j].c, ch); /* Attach 'ch' to 
							space between data */
	    break;
	  case EOF:
	    stop = 1;	/* At end of file!  stop everything! */
	    break;
	  case '\0':
	    fprintf (stderr, "Not set up to handle \0 characters in ASCII files.  Stop.\n");
	    exit (1);
	  default:	/* Affix character to 'line' */
	    line[linelen++] = ch;
	    line[linelen] = '\0';
	    if (linelen == 800) {
	      fprintf (stderr, "%s: Line too long -- copying over.", argv[0]);
	      fprintf (outfile, "%s", line);
	      linelen = 0;
	      line[0] = '\0';
	    }
	}
      }

/* if no more data, print final characters and exit */

      if (j == 0) {
	fprintf (outfile, "%s", space[0].c);
	break;
      }

/* If not enough data given to finish final chunk, change chunk size */

      if (stop) chunk = j+1;

/* Apply function to data */

      if (target != INT_NOT_FLOAT) float_function (x, y, index-chunk);
      else integer_function (m, n, index-chunk);

/* output */

      for (j=0; j<chunk; j++) {
	fprintf (outfile, "%s", space[j].c);
	if (target != INT_NOT_FLOAT) fprintf (outfile, fformat, y[j]);
	else fprintf (outfile, "%d", (int) n[j]);
      }
      fprintf (outfile, "%s", space[chunk].c);
    }
    free (space);
    while ((ch = getc (infile)) != EOF) {   /* If we exited because of -tail,
					     we have to copy remaining data */
    putc (ch, outfile);
    }
  }

/* Now: binary case */

  else {
    for (i=0; i<skip; i++) {	/* Copy first 'skip' bytes without processing */
      ch = getc(infile);
      putc (ch, outfile);
    }
    stop = 0;
    index = 0;
    while ((!stop) && ((tail<0) || (index < tail-skip))) {
      for (j=0; ((j<chunk) && (!stop)); j++) {
	m[j] = getc (infile);
	if (m[j] == EOF) {
	  stop=1;
	  break;
	}
	index++;
      }
      if (j==0) break;
      if (stop) chunk = j;
      integer_function (m, n, index - chunk);
      for (j=0; j<chunk; j++) {
	if (n[j]<0) n[j] = 0;
	else if (n[j]>255) n[j] = 255;
	putc (n[j], outfile);
      }
    }	/* Now copy any remaining bytes after -tail */
    if (!stop) while ((ch = getc (infile)) != EOF) {
      putc (ch, outfile);
    }
  }
  if (target == INT_NOT_FLOAT) {
    free (n);
    free (m);
  } else {
    free (y);
    free (x);
  }
}
