#include "extern.h"
	
Bool	inside(i, j)
/* Return TRUE if the (i,j) entry of DCirc is an interior circle in the circle domain */
int	i, j;
{
	int	mynbrs[6], mypos[6][2], n;
	Bool	notoutside, connected;
	
	getccindices(i, j, mypos);
	/* Get neighboring circle states */
	for (n=0; n<NUMNBRS; ++n)	
		mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].state;
	notoutside = TRUE;
	connected = FALSE;
	/* Check whether any neighbors are outside region and 
	whether any neighbor is interior */
	for (n=0; n<6; ++n)	{
		if (mynbrs[n] <= OUTSIDE)	notoutside = FALSE;
		if (mynbrs[n] == INTERIOR)	connected = TRUE;
	}
	if ((DCirc[j+i*width].state == CANDIDATE)
	&& (notoutside) && (connected))	
		return(TRUE);
	else
		return(FALSE);
} /*inside*/


konnect(u, v)
/* Recursively find the component of the circle domain connected to the (u,v) entry */
int	u, v;
{
	int	mypos[6][2], i, j, k;
	Bool	morepoints;
	
	if ((u>0) && (v>0)
	&& (u<height-1) && (v<width-1))	{
		if (inside(u,v))
		/* This circle is interior */
			DCirc[v+u*width].state = INTERIOR;
		getccindices(u, v, mypos);
		/* Check whether the neighbors are interior */
		for (i=0; i<NUMNBRS; ++i)	{
			j = mypos[i][0];
			k = mypos[i][1];
			if ((DCirc[k+j*width].state == CANDIDATE)
			&& (j>0) && (k>0)
			&& (j<height-1) && (k<width-1))	
				if (inside(j, k))	
				/* This circle is interior */
					DCirc[k+j*width].state = INTERIOR;
		}
	}
	morepoints = FALSE;
	/* Check whether we have the largest flower-connected component */
	for (i=1; i<height-1; ++i)	{
		for (j=1; j<width-1; ++j)	{
			if (inside(i, j))	{
				morepoints = TRUE;
				goto foundmore;
			}
		}
	}

	foundmore:	{
		if (morepoints)
		/* Must connect more circles */
			konnect(i, j);
	}
} /*konnect*/
	
			
				
findboundary()
/* Assuming that interior circles have already been labeled as such, */
/* this function labels the boundary circles */
/* Note: Some circles lying inside the bounding curves may be discarded */
{
	int	i, j, mypos[6][2], mynbrs[6], n, indx;
	Bool	connected;
	
	/* Scan for non-INTERIOR circles */
	for (i=1; i<height-1; ++i)	{
		for (j=1; j<width-1; ++j)	{
			indx = j+i*width;
			if (DCirc[indx].state == CANDIDATE)	{
			/* This circle's center is in the disk */
				getccindices(i, j, mypos);
				/* Get the neighboring circle states */
				for (n=0; n<NUMNBRS; ++n)	
					mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].state;
				connected = FALSE;
				/* Check whether a neighbor is INTERIOR */
				for (n=0; n<NUMNBRS; ++n)	
					if (mynbrs[n] == INTERIOR)	connected = TRUE;

				if (connected)	
				/* This circle is a boundary circle */
					DCirc[indx].state = OUTERBDRY;
			}
		}
	}	
	for (i=0; i<hw; ++i)	
	/* Leftover circles in region must be discarded */
		if (DCirc[i].state == CANDIDATE)	DCirc[i].state = OUTSIDE;
} /*findboundary*/


findfix()
/*Find two boundary circles of fixed radius.*/
/*By convention, we choose the lower right circle and its neighbor to the left */
	
{
	int 		i, j;	
	Bool		notfixed;

	i = height-1;
	j = width-1;
	notfixed = TRUE;
	while (notfixed)	{
		if (DCirc[j+i*width].state == OUTERBDRY) {
		/* Found lower right circle */
			fixradi = i;
			fixradj = j;
			notfixed = FALSE;
		} /*if*/
		else	{
			if (j>0)	--j;
			else	{
				j = width-1;
				--i;
			}
		} /*else*/
	} /*while*/
} /*findfix*/

assigncolor()
/* assign colors constant on hexagonal generations concentric with the nullpoint */
{
	int		i, j, k, generation, maxgen, max, mynbrs[6], mypos[6][2], n;
	float		colorstep;

	if (width>height)	max = width;
	else	max = height;
	for (i=0; i<hw; ++i)	
		DCirc[i].cnum = 0;
	DCirc[nullj+nulli*width].cnum = 1;
	generation = maxgen = 1;

	for (k=0; k<max; ++k)	{	
	/* label the next concentric hexagon via the .cnum flag */
		for (i=1; i<height-1; ++i)	{
			for (j=1; j<width-1; ++j)	{	
				if (DCirc[j+i*width].cnum == 0)	{
				/* check whether the (i,j) entry has a neighbor on the last hexagon */
					getccindices(i, j, mypos);
					for (n=0; n<NUMNBRS; ++n)	{
						mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].cnum;
						if (mynbrs[n] == generation)	{
							DCirc[j+i*width].cnum = generation+1;
							maxgen = generation+1;
							break;
						}
					}
				}
			}
		}
		generation++;
	}
	/* assign colors constant on hexagons */
	for (i=0; i<numcircles; ++i)
		mycolor[i] = 255 - (11*DCirc[circindex[i]].cnum)%253;
	for (i=0; i<height*width; ++i)	
		DCirc[i].cnum = 0;
} /*assigncolor*/

docycle(a, b, bdrystate)
/* Given a cycle of circles starting at (a,b) and having the same state, this function*/
/* changes the state of all circles in this cycle to bdrystate */
int	a, b, bdrystate;
{
	int	i, j, count, state[6], pos[6][2], cyclelength, oldstate;
	Bool	cycling, searching;
	
	/* Present state of cycle */
	oldstate = DCirc[b+a*width].state;
	DCirc[b+a*width].state = bdrystate;
	i = a;
	j = b;
	cyclelength = 1;
	cycling = TRUE;

	/* Traverse cycle */
	do {
		getccindices(i, j, pos);
		/* Store neighboring states */
		for (count=0; count<NUMNBRS; ++count)	
			state[count] = DCirc[pos[count][1]+pos[count][0]*width].state;
		count = 0;
		searching = TRUE;
		do {
			if (count == NUMNBRS)	{
			/* Cycle has been traversed */
				cycling = FALSE;
				break;
			}
			else	{
				if (state[count] == oldstate)	{
				/* Found the next circle in the cycle */
					searching = FALSE;
					i = pos[count][0];
					j = pos[count][1];

					/* Change its state to bdrystate */
					DCirc[j+i*width].state = bdrystate;
					++cyclelength;
				}
			}
		++count;
		} while (searching);
	} while (cycling);
} /*docycle*/
