
#include "extern.h"

fillcircles(rad)
/* Fill the circle of diameter WINSIZE with the regular hexagonal packing of mesh rad */
double	rad;
{
	int		i, j, indx, m, n;
	double		u, v, w, ctrnorm, nullnorm, startx, starty, dx, dy, winctr, diskdiam, diskrad;
	
	winctr = WINSIZE/2.0;
	nullnorm = WINSIZE;

	/* diameter of disk drawn on domain window */
	diskdiam = 0.9*WINSIZE;
	diskrad = diskdiam/2.0;

	/* horizontal and vertical increments to circle centers */
	dx = 2.0*rad;
	dy = ROOT3*rad;

	/* dimensions of circle arrays */
	width = 6 + diskdiam/dx;
	height = 6 + diskdiam/dy;
	hw = (width-1)*(height-1)+1;

	initcircs();

	/* Scan so one coordinate is the center of the disk */
	m = diskrad/dx + 3;
	startx = WINSIZE/2.0 - m*dx;
	n = diskrad/dy + 3;
	if (n%2 == 0)	n++;
	starty = WINSIZE/2.0 - n*dy;
	v = starty;

	/* Loop through, checking whether each admissible circle lies in the region */
	for (i=0; i<height; ++i)	{
		/* Increment vertical coordinate */
		v += dy;
		if (i%2 == 0)	u = startx - dx;
		else	u = startx - rad;
		for (j=0; j<width; ++j)	{
			/* Increment horizontal coordinate */
			u += dx;

			/* Distance between centers */
			ctrnorm = sqrt((u-winctr)*(u-winctr)+(v-winctr)*(v-winctr));

			/* Check whether this circle is closer to the center than the previous */
			if (nullnorm > ctrnorm)	{
				/* Yes, this circle is the new candidate for the nullcircle */
				nullnorm = ctrnorm;
				nulli = i;
				nullj = j;
			}
			if (ctrnorm < diskrad)	{
				/* This circle's center lies in the disk.
				Record fact in circleinfo array DCirc */
				indx = j+i*width;
				DCirc[indx].x = u;
				DCirc[indx].y = v;
				DCirc[indx].r = rad;
				DCirc[indx].state = CANDIDATE;
			}
		}
	} 
	XFlush(dpy);
} /*fillcircles*/
