/*ScianScrDump.c
  Eric Pepke
  May 22, 1991
  Screen dump pseudorecorder*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianWindows.h"
#include "ScianIDs.h"
#include "ScianScrDump.h"

long curFrame = 0;

static ObjPtr ReturnTrue(object)
ObjPtr object;
/*Returns true*/
{
    return ObjTrue;
}

static ObjPtr PrepareToRecordScrDump(object, nFrames)
ObjPtr object;
long nFrames;
/*Prepares to record nframes*/
{
    curFrame = 0;
    return ObjTrue;
}

static ObjPtr SnapOneFrameScrDump(object)
ObjPtr object;
/*Do a screen dump of arbitrary size*/
{
    sprintf(tempStr, "scrsave dump%04d.rgb 0 %d 0 %d", 
		++curFrame, recScrWidth, recScrHeight);
    system(tempStr);
    return ObjTrue;
}

ObjPtr NewScrDump()
/*Return a new screen dump ersatz recorder*/
{
    ObjPtr retVal;
    retVal = NewObject(NULLOBJ, 0);
    SetVar(retVal, NAME, NewString("scrsave"));
    SetMethod(retVal, CONNECT, ReturnTrue);
    SetMethod(retVal, DISCONNECT, ReturnTrue);
    SetMethod(retVal, PREPARETORECORD, PrepareToRecordScrDump);
    SetMethod(retVal, STOPRECORDING, ReturnTrue);
    SetMethod(retVal, SNAPONEFRAME, SnapOneFrameScrDump);
    return retVal;
}
