#include <StdIO.h>;
#include <Dialogs.h>;
#include <Windows.h>;
#include <Math.h>;
#include <Packages.h>;
#include <Memory.h>;
#pragma segment Conversion

short GetValue(Str255);
/*
 *	
 *	Boolean GetRawPalette (theImage, fName);
 *	
 *	This routine will use a macintosh dialog box to get the dimensions of the raster image.
 *	This is necessary if the file was a raw raster file where the dimensions of the image
 *	are in no way specified within the file.
 *	
 */

unsigned char * GetRawPalette (char *, short);

unsigned char * GetRawPalette (Name, RefNum)
	char * Name;
	short RefNum;
{
	short tmp;
	unsigned char colors[3][256];
	unsigned char * npal;
	long count = 768;
	int i;
	
	/* open the file. */
	
	npal = (unsigned char *) NewPtr (768);
	if (!npal)
		return NULL;
		
	if (noErr != fsopen (Name, RefNum, &tmp))
		return NULL;
		
	/* write the file. */
	
	if (noErr != FSRead (tmp, &count, (Ptr)colors))
		return NULL;
		
	FSClose (tmp);
	
	/* set the color table to the values read from the file. */
	
	for (i = 0; i < 256; i++)
		{
		npal[i*3] = colors[0][i];
		npal[i*3+1] = colors[1][i];
		npal[i*3+2] = colors[2][i];
		}
		
	return npal;
}

/*
 *	
 *	GetHDFPalette()
 *	
 *	Save a palette to an HDF file.
 *	
 */
 
unsigned char * GetHDFPalette(char *);

unsigned char * GetHDFPalette(defaultFileName)
	char * defaultFileName;
{
	unsigned char	*npal;
	/* read the palette from an HDF file. */

	npal = (unsigned char *) NewPtr (768);
	if (!npal)
		return NULL;
		
	if (DFPgetpal((char *) defaultFileName, npal) < 0)
		return NULL;
	DFPrestart (defaultFileName);
	return npal;
}
	
unsigned char * GetPalette()
	
{
	char volName [256];
	SFReply myReplyRec;
	Point thePoint;
	
	SetPt(&thePoint,50,50);
	SFGetFile(thePoint,"Choose a Palette File",nil,0,nil,nil,&myReplyRec);

	if (myReplyRec.good) 
		{
		SetVol (volName, myReplyRec.vRefNum);
		p2cstr (myReplyRec.fName);
		if (DFishdf(myReplyRec.fName) != -1)	/* is it HDF? */
			return GetHDFPalette (myReplyRec.fName);
		else
			return GetRawPalette (myReplyRec.fName, myReplyRec.vRefNum);
		}
	else return (0);
}
	
	

short RawToRI8(theName,theData,dim1,dim2,pal)
	char *theName;
	unsigned char **theData;
	long *dim1;
	long *dim2;
	char **pal;
{
	short xdim,ydim,pFlag;
	unsigned char *DATA;
	
	if (0 == DoTheDialog(&xdim,&ydim,&pFlag))
		return (1);
		
	*dim1 = xdim;
	*dim2 = ydim;
				
	if (pFlag ==1)
		*pal = GetPalette();	

	if (0 == DoTheRawData(theName,xdim,ydim,&DATA)) return (1);
	else *theData = DATA;

	return (0);
}





unsigned char * TheOleSwitcheroo(theColors)
     unsigned char *theColors;
{
  int s,d;
  unsigned char *theNewColors;
  

  theNewColors = (unsigned char *)malloc(768);
  
  for(s=d=0;s < 256;s++,d++)
    {
      *(theNewColors + d) = *(theColors +s);
      d++;
      *(theNewColors + d) = *(theColors +256 +s);
      d++;
      *(theNewColors + d) = *(theColors +512 +s);
    }  
	return (theNewColors);
}

/*
 *	DoTheDialog (dim1, dim2, palFlag)
 *
 *	This routine will get the dimensions of the raw raster file image. It will also
 *	tell you if a palette is required.
 *
 */

/* the item numbers. */

#define MYDIALOGID 1000

#define OK_I		1
#define CANCEL_I	2
#define XDIM_I		3
#define YDIM_I		4
#define PAL_I		5

DoTheDialog(dim1,dim2,palFlag)
	short *dim1;
	short *dim2;
	short *palFlag;

{
	Str255 x,y;
	short itemHit;
	Handle xHandle,yHandle,palItem;
	Rect box;
	short type;
	short xval,yval;
	WindowPtr theDialog;

	
	theDialog = GetNewDialog(MYDIALOGID,(Ptr) NULL,(WindowPtr) -1);
	GetDItem(theDialog,XDIM_I,&type,&xHandle,&box);
	GetDItem(theDialog,YDIM_I,&type,&yHandle,&box);
	*palFlag =0;

	do {
		ModalDialog(NULL,&itemHit);
		
		switch(itemHit)
			{
				case OK_I:
					GetIText(xHandle, &x);
					GetIText(yHandle, &y);
					xval = GetValue(x);
					yval = GetValue(y);
					
					*dim1 = xval;
					*dim2 = yval;
					break;
					
				case CANCEL_I:
					*dim1 = *dim2 = 0;
					*palFlag = 0;
					DisposDialog(theDialog);
					return (0);
					break;
					
				case PAL_I:
					GetDItem (theDialog, PAL_I, &type, &palItem, &box);
					if (0 == *palFlag)
						{
						*palFlag =1;
						SetCtlValue ((ControlHandle) palItem, (short) 1);
						}
					else 
						{
						*palFlag =0;
						SetCtlValue ((ControlHandle) palItem, (short) 0);
						}

					break;
					
		} 
	} while (itemHit != OK_I && itemHit != CANCEL_I);
	
	DisposDialog(theDialog);
	if (itemHit == OK_I) return 1;
	else	return 0;
}



short GetValue(theStr)
	Str255 theStr;

{
	short theVal;
	
	p2cstr (theStr);
	theVal = atoi (theStr);

	return (theVal);
}		
		
	
DoTheRawData(myName,dim1,dim2,theData)
	char *myName;
	long dim1,dim2;
	unsigned char **theData;	
	
{
	long length;
	FILE *fp;

   if (NULL == (fp = fopen(myName,"rbw+")))
       return (0);
	
	length = (dim1*dim2);
	*theData = (unsigned char *)NewPtr(length);
	
	if (length > fread(*theData,1,length,fp)) return (0);	
	else return (1);
}



