#define FM_SYSTEM
#include "fm.h"
int fmmd_(long *ma, double *x)
{
	long i__1;
	double	log(double), pow_di(double, long);
	static double pmax;
	static long kwsv, j;
	static double y;
	static long ncase;
	static double xbase;
	static long n1;
	static double rzero;
	static float dlogjb, dlogdp;
	static double yt;
	static long ma1, ma2;
	static double one;
	--ma;
	pmax = fm_1.dpmax;
	if (fm_1.ncall > 0) {
		if (fm_1.kstack[fm_1.ncall - 1] == 25)
			pmax = fm_1.spmax;
	}
	dlogjb = log((double) fmuser_1.jbase);
	dlogdp = log(pmax);
	ma1 = ma[1];
	ncase = 0;
	if ((double) (ma[1] - 1) * dlogjb > dlogdp) {
		fmuser_1.kflag = -4;
		*x = fm_1.runkno;
		fmwarn();
		return 0;
	} else if ((double) (ma[1] + 1) * dlogjb > dlogdp) {
		ma[1] += -2;
		ncase = 1;
	} else if ((double) (ma[1] + 1) * dlogjb < -(double)dlogdp) {
		fmuser_1.kflag = -10;
		*x = 0.;
		fmwarn();
		return 0;
	} else if ((double) (ma[1] - 1) * dlogjb < -(double)dlogdp) {
		ma[1] += 2;
		ncase = 2;
	}
	kwsv = fmuser_1.kwarn;
	fmuser_1.kwarn = 0;
	fmmi_(&ma[1], &j);
	fmuser_1.kwarn = kwsv;
	if (fmuser_1.kflag == 0) {
		*x = (double) j;
		return 0;
	}
	fmuser_1.kflag = 0;
	ma2 = ma[2];
	ma[2] = abs(ma2);
	rzero = 0.f;
	one = 1.f;
	n1 = fmuser_1.ndig + 1;
	xbase = (double) fmuser_1.jbase;
	*x = rzero;
	y = one;
	for (j = 2; j <= n1; ++j) {
		y /= xbase;
		yt = (double) ma[j];
		*x += y * yt;
		yt = one + y * xbase;
		if (yt <= one)
			goto L120;
	}
L120:
	*x *= pow_di(xbase, ma[1]);
	if (ma2 < 0)
		*x = -(*x);
	ma[2] = ma2;
	if (ncase == 1) {
		if (*x <= pmax / (xbase * xbase))
			*x = *x * xbase * xbase;
		else {
			fmuser_1.kflag = -4;
			*x = fm_1.runkno;
			fmwarn();
		}
	} else if (ncase == 2) {
		if (*x >= 1. / pmax * xbase * xbase)
			*x /= xbase * xbase;
		else {
			fmuser_1.kflag = -10;
			*x = 0.;
			fmwarn();
		}
	}
	ma[1] = ma1;
	return 0;
} /* fmmd_ */
