* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                           *  STATE PLANE  *
* **********************************************************************
*
      SUBROUTINE PJ02Z0
*
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*32 PNAME
      INTEGER*4 ID
      INTEGER*4 SWITCH,ZONE
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DIMENSION BUFFL(13)
      DIMENSION ITEM(135),TABLE(9)
      DATA ITEM /0101,0102,5010,5302,0201,0202,0203,0301,0302,0401,
     .           0402,0403,0404,0405,0406,0407,0501,0502,0503,0601,
     .           0701,0901,0902,0903,1001,1002,5101,5102,5103,5104,
     .           5105,1101,1102,1103,1201,1202,1301,1302,1401,1402,
     .           1501,1502,1601,1602,1701,1702,1703,1801,1802,1901,
     .           2001,2002,2101,2102,2103,2111,2112,2113,2201,2202,
     .           2203,2301,2302,2401,2402,2403,2501,2502,2503,2601,
     .           2602,2701,2702,2703,2801,2901,3001,3002,3003,3101,
     .           3102,3103,3104,3201,3301,3302,3401,3402,3501,3502,
     .           3601,3602,3701,3702,3801,3901,3902,4001,4002,4101,
     .           4201,4202,4203,4204,4205,4301,4302,4303,4401,4501,
     .           4502,4601,4602,4701,4702,4801,4802,4803,4901,4902,
     .           4903,4904,5001,5002,5003,5004,5005,5006,5007,5008,
     .           5009,5301,5201,5202,5401/
      DATA ZERO /0.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS02Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      IF (ZONE .LE. 0) GO TO 050
      IZONE = ZONE
      IF (MOD(IZONE,100) .EQ. 0) IZONE = IZONE + 1
      DO 040 IND = 1,135
      IF (IZONE .EQ. ITEM(IND)) GO TO 060
  040 CONTINUE
  050 IF (IPFILE .NE. 0) WRITE (IPFILE,2000) ZONE
 2000 FORMAT (' ILLEGAL ZONE NO = ',I6)
      IFLG = 201
      RETURN
  060 OPEN (UNIT=99,FILE='ZONESDATA',STATUS='OLD',
     .      ACCESS='DIRECT',RECL=27)
      READ (99'IND) PNAME,ID,TABLE
      CLOSE (UNIT=99,STATUS='KEEP')
      IF (ID .LE. 0) GOTO 050
      ITYPE = ID
      IF (DATA(1) .NE. ZERO) TABLE(1) = DATA(1)
      IF (DATA(2) .NE. ZERO) TABLE(2) = DATA(2)
      BUFFL(1) = TABLE(1)
      BUFFL(2) = TABLE(2)
      GO TO (080,090,100,110) , ITYPE
*
* TRANSVERSE MERCATOR PROJECTION
*
  080 BUFFL(3) = TABLE(4)
      BUFFL(5) = TABLE(3)
      BUFFL(6) = TABLE(7)
      BUFFL(7) = TABLE(8)
      BUFFL(8) = TABLE(9)
      CALL IS09Z0 (ZONE,BUFFL,IPFILE,IFLG)
      GO TO 120
*
* LAMBERT CONFORMAL PROJECTION
*
  090 BUFFL(3) = TABLE(6)
      BUFFL(4) = TABLE(5)
      BUFFL(5) = TABLE(3)
      BUFFL(6) = TABLE(7)
      BUFFL(7) = TABLE(8)
      BUFFL(8) = TABLE(9)
      CALL IS04Z0 (ZONE,BUFFL,IPFILE,IFLG)
      GO TO 120
*
* POLYCONIC PROJECTION
*
  100 BUFFL(5) = TABLE(3)
      BUFFL(6) = TABLE(4)
      BUFFL(7) = TABLE(5)
      BUFFL(8) = TABLE(6)
      CALL IS07Z0 (ZONE,BUFFL,IPFILE,IFLG)
      GO TO 120
*
* OBLIQUE MERCATOR PROJECTION
*
  110 BUFFL(3) = TABLE(4)
      BUFFL(4) = TABLE(6)
      BUFFL(5) = TABLE(3)
      BUFFL(6) = TABLE(7)
      BUFFL(7) = TABLE(8)
      BUFFL(8) = TABLE(9)
      BUFFL(13) = 1.0
      CALL IS20Z0 (ZONE,BUFFL,IPFILE,IFLG)
*
  120 IF (IFLG .NE. 0) RETURN
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010) PNAME
 2010 FORMAT (' INITIALIZATION PARAMETERS (STATE PLANE PROJECTION)'/
     .        ' ZONE = ',A32)
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF02Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 140
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 200
      RETURN
  140 GO TO (160,170,180,190) , ITYPE
*
* TRANSVERSE MERCATOR PROJECTION
*
  160 CALL PF09Z0 (GEOG,PROJ,IFLG)
      GO TO 200
*
* LAMBERT CONFORMAL PROJECTION
*
  170 CALL PF04Z0 (GEOG,PROJ,IFLG)
      GO TO 200
*
* POLYCONIC PROJECTION
*
  180 CALL PF07Z0 (GEOG,PROJ,IFLG)
      GO TO 200
*
* OBLIQUE MERCATOR PROJECTION
*
  190 CALL PF20Z0 (GEOG,PROJ,IFLG)
*
  200 RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI02Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 300
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
      IFLG = 200
      RETURN
  300 GO TO (320,330,340,350) , ITYPE
*
* TRANSVERSE MERCATOR PROJECTION
*
  320 CALL PI09Z0 (PROJ,GEOG,IFLG)
      GO TO 360
*
* LAMBERT CONFORMAL PROJECTION
*
  330 CALL PI04Z0 (PROJ,GEOG,IFLG)
      GO TO 360
*
* POLYCONIC PROJECTION
*
  340 CALL PI07Z0 (PROJ,GEOG,IFLG)
      GO TO 360
*
* OBLIQUE MERCATOR PROJECTION
*
  350 CALL PI20Z0 (PROJ,GEOG,IFLG)
*
  360 RETURN
*
      END
