* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      DOUBLE PRECISION FUNCTION PHI3Z0 (ML,E0,E1,E2,E3,IPFILE,IFLG)
*
* FUNCTION TO COMPUTE LATITUDE ANGLE (PHI-3).
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 II,NIT,IPFILE,IFLG
      DATA TWO,FOUR,SIX /2.0D0,4.0D0,6.0D0/
      DATA TOL,NIT /1.0D-11,15/
*
      PHI = ML
      DO 020 II = 1,NIT
      DPHI = (ML + E1 * DSIN (TWO * PHI) - E2 * DSIN (FOUR * PHI) +
     .        E3 * DSIN (SIX * PHI)) / E0 - PHI
      PHI = PHI + DPHI
      IF (DABS(DPHI) .GT. TOL) GO TO 020
      PHI3Z0 = PHI
      RETURN
  020 CONTINUE
*
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000)
 2000 FORMAT (' LATITUDE FAILED TO CONVERGE')
      IFLG = 23
      RETURN
*
      END
