* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      DOUBLE PRECISION FUNCTION PHI1Z0 (ECCENT,QS,IPFILE,IFLG)
*
* FUNCTION TO COMPUTE LATITUDE ANGLE (PHI-1).
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 II,NIT,IPFILE,IFLG
      DATA HALF,ONE /0.5D0,1.0D0/
      DATA EPSLN,TOL,NIT /1.0D-7,1.0D-10,15/
*
      PHI1Z0 = ASINZ0 (HALF * QS)
      IF (ECCENT .LT. EPSLN) RETURN
*
      ECCNTS = ECCENT * ECCENT
      PHI = PHI1Z0
      DO 020 II = 1,NIT
      SINPI = DSIN (PHI)
      COSPI = DCOS (PHI)
      CON = ECCENT * SINPI
      COM = ONE - CON * CON
      DPHI = HALF * COM * COM / COSPI * (QS / (ONE - ECCNTS) -
     .       SINPI / COM + HALF / ECCENT * DLOG ((ONE - CON) /
     .       (ONE + CON)))
      PHI = PHI + DPHI
      IF (DABS(DPHI) .GT. TOL) GO TO 020
      PHI1Z0 = PHI
      RETURN
  020 CONTINUE
*
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000)
 2000 FORMAT (' LATITUDE FAILED TO CONVERGE')
      IFLG = 21
      RETURN
*
      END
