/* SCCS @(#)type.h	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          type.h                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   type.h                                              */
/*                                                                      */
/* DESCRIPTION  :   data structure types of LaboImage                   */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include "define.h"

struct lecture_lts {
    FILE    *fp_lts;
    char    filename[60];
    int	    header, nlignes, nbytes, nvaleur, bytes_sautes;
};

struct fname {
    FILE    *fpim, *fpdesc;
    char    filename[60];
};

struct frasname {
    FILE    *fpim;
    char    filename[60];
};

struct convert {
    float   mind, maxd, mina, maxa;
    int	    flag_mind, flag_maxd, flag_mina, flag_maxa;
};

struct cte_cmplx {
    float   reel, im;
};

struct histogr {
    int		*tab_hist;
    int		larg_barre, haut_barre;
    struct fname *fileps;
};

struct convol {
    int	    ligne, colonne;
    float   factmult;
    float   *masque;
};

struct	affin {
    float   c1, c2;
};

struct cut_s {
    int XMin, YMin, XMax, YMax;
};

struct count_s {
    int SMin, XEt, YEt, SEt;
    char FN_Res[60];
};

struct mati_s {
    float Mat[50]
};

struct profil_s {
    short   X1,Y1,X2,Y2,Largeur,NPr, flag_dentist;
    short   sXMin[MAX_PROFIL],sXMax[MAX_PROFIL];
    float   DX, DY;
    float   vmin[MAX_PROFIL], vmax[MAX_PROFIL], total[MAX_PROFIL];
    float   *Vals[MAX_PROFIL],Coef[MAX_PROFIL][4];
    char    filename[MAX_PROFIL][30];
    char    *aff_profil[MAX_PROFIL];
};

struct element {
    short   type, param1, param2;
    float   param3, param4, param5;
};

struct morphobin {
    int	taille, angle;
};

struct paddi {
    int	    ligne, colonne, methode;
    int	    flag_moy;
    float   valeur;
};

struct filmed {
    int	    nlin, ncol;
};

struct pertile {
    float   ptiledata;    /* parameter for laplac_p_tile histogram   */
    int	    n_block;	  /* parameter for dynamic threshold         */
    float   alpha;	  /* parameter for high_pass filter	     */
};

struct rayon_puissan {
    float   p_energy;	  /* percentage for keeping energy	     */
    int	    r_frequency;  /* corresponding radius in frequency domain*/
    int	    n_point;	  /* points of interpolation		     */
};

struct gaussian_p {
    float   en_mint;	  /* ratio of en over mint		    */
    int	    mint;	  /* diameter of gaussian window	    */
};

struct sommet {
    float   min_thr;
    float   max_thr;
    int	    length;
};

struct	noise {
    double   esp, var;
};


struct prcd { 
    int	    x;
    int	    y;
    float   val;
};


