/* SCCS @(#)oparithm4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      oparithm4.c                                     */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   oparithm4.c                                         */
/*                                                                      */
/* DESCRIPTION  :   Arithmetic operations                               */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>

#include "type.h"

union ens_pointeur {
    float   *pf;
    int	    *pi;
    short   *ps;
    unsigned char   *pb;
};


/*****************************************************************************/

int ouvrir (pim, image, type, ordre)
union ens_pointeur *pim;
unsigned char *image;
int type, ordre;
{
    static  int	code[2][5] = {0, 0,  3,  7,  12,
			      0, 0, 30, 70, 120};

    switch (type) {
	case -1:
	case 0:	pim->pb = (unsigned char *) image; break;
	case 1:	pim->ps = (short *)	    image; break;
	case 2:	pim->pi = (int *)	    image; break;
	case 3:	pim->pf = (float *)	    image; break;
    }
    return (code[ordre][type + 1]);
}


/*****************************************************************************/

int 
op_arithm (mode, imageIn, type, imageIn2, type2, colonne, ligne, 
	   imageOut, typearr)
    int mode, type, type2, colonne, ligne, *typearr;
    unsigned char *imageIn, *imageIn2;
    unsigned char **imageOut;
{
    union ens_pointeur pim[2];
    int	*pires;
    float *pfres;
    int	code, taille;
    register int i;

    code = ouvrir (&pim[0], imageIn, type, 0) + 
           ouvrir (&pim[1], imageIn2, type2, 1);
    taille = ligne * colonne;

    if (code==120 || code==12 || code==123 || code==42 || code==127 || code==82
     || code==132 || mode==24) {
        pfres = (float *) malloc (taille * sizeof(*pfres));
        *imageOut = (unsigned char *) pfres;
        *typearr = 3;
    }
    else {
	pires = (int *) malloc (taille * sizeof(*pires));
        *imageOut = (unsigned char *) pires;
	*typearr = 2;
    }
    switch (code){
	case 0	:   /* b,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) + *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) - *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) * *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) / *(pim[1].pb);
			pires++;  (pim[0].pb)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 30	:   /* b,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) + *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) - *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) * *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) / *(pim[1].ps);
			pires++;  (pim[0].pb)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 3	:   /* s,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) + *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) - *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) * *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) / *(pim[1].pb);
			pires++;  (pim[0].ps)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 70	:   /* b,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) + *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) - *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) * *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pb) / *(pim[1].pi);
			pires++;  (pim[0].pb)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 7	:   /* i,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) + *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) - *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) * *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) / *(pim[1].pb);
			pires++;  (pim[0].pi)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 120:   /* b,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) + *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) - *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) * *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pb) / *(pim[1].pf);
			pfres++;  (pim[0].pb)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
	case 12	:   /* f,b */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].pb);
			pfres++;  (pim[0].pf)++;  (pim[1].pb)++;
		    }
		    break;
	    }
	    break;
	case 33	:   /* s,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) + *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) - *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) * *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) / *(pim[1].ps);
			pires++;  (pim[0].ps)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 73	:   /* s,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) + *(pim[1].pi);
			pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) - *(pim[1].pi);
			pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) * *(pim[1].pi);
			pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].ps) / *(pim[1].pi);
		        pires++;  (pim[0].ps)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 37	:   /* i,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) + *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) - *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) * *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) / *(pim[1].ps);
			pires++;  (pim[0].pi)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 123:   /* s,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) + *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) - *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) * *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].ps) / *(pim[1].pf);
			pfres++;  (pim[0].ps)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
	case 42	:   /* f,s */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].ps);
			pfres++;  (pim[0].pf)++;  (pim[1].ps)++;
		    }
		    break;
	    }
	    break;
	case 77	:   /* i,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) + *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) - *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) * *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pires = *(pim[0].pi) / *(pim[1].pi);
			pires++;  (pim[0].pi)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 127:   /* i,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) + *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) - *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) * *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pi) / *(pim[1].pf);
			pfres++;  (pim[0].pi)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
	case 82	:   /* f,i */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].pi);
			pfres++;  (pim[0].pf)++;  (pim[1].pi)++;
		    }
		    break;
	    }
	    break;
	case 132:   /* f,f */
	    switch (mode) {
	    case 20: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) + *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    case 21: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) - *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    case 22: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) * *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    case 23: for (i=0; i<taille; i++) {
			*pfres = *(pim[0].pf) / *(pim[1].pf);
			pfres++;  (pim[0].pf)++;  (pim[1].pf)++;
		    }
		    break;
	    }
	    break;
    }
}


/*****************************************************************************/

int
op_arithm_cmplx (imageIn1r, type1r, imageIn1i, type1i, 
		 imageIn2r, type2r, imageIn2i, type2i, colonne, ligne, 
		 imageOutr, imageOuti, typearr)
    unsigned char *imageIn1r, *imageIn1i, *imageIn2r, *imageIn2i;
    int type1r, type1i, type2r, type2i;
    int colonne, ligne, *typearr;
    unsigned char **imageOutr, **imageOuti;
{
    union ens_pointeur pim[4];
    float *pfres_r, *pfres_im;
    int *pires_r, *pires_im;
    int	code, taille;
    register int i;

    /* le plan reel et imaginaire d'une image doit etre de meme type */
    code = (ouvrir (&pim[0], imageIn1r, type1r, 0) + 
	    ouvrir (&pim[1], imageIn1i, type1i, 0)) / 2 +
	   (ouvrir (&pim[2], imageIn2r, type2r, 1) + 
	    ouvrir (&pim[3], imageIn2i, type2i, 1)) / 2 ;
    taille = ligne * colonne;

    if (code==120 || code==12 || code==123 || code==42 || code==127 || code==82
     || code==132) {
        pfres_r = (float *) malloc (taille * sizeof(*pfres_r));
        pfres_im = (float *) malloc (taille * sizeof(*pfres_im));
	*imageOutr = (unsigned char *) pfres_r;
	*imageOuti = (unsigned char *) pfres_im;
        *typearr = 3;
    }
    else {
	pires_r = (int *) malloc (taille * sizeof(*pires_r));
	pires_im = (int *) malloc (taille * sizeof(*pires_im));
	*imageOutr = (unsigned char *) pires_r;
	*imageOuti = (unsigned char *) pires_im;
	*typearr = 2;
    }

    switch (code){
	case 0	:   /* b,b */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pb) * *(pim[2].pb) - 
			   *(pim[1].pb) * *(pim[3].pb);
		*pires_im = *(pim[0].pb) * *(pim[3].pb) +
			    *(pim[1].pb) * *(pim[2].pb);
		pires_r++;  pires_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 30	:   /* b,s */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pb) * *(pim[2].ps) - 
			   *(pim[1].pb) * *(pim[3].ps);
		*pires_im = *(pim[0].pb) * *(pim[3].ps) +
			    *(pim[1].pb) * *(pim[2].ps);
		pires_r++;  pires_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 3	:   /* s,b */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].ps) * *(pim[2].pb) - 
			   *(pim[1].ps) * *(pim[3].pb);
		*pires_im = *(pim[0].ps) * *(pim[3].pb) +
			    *(pim[1].ps) * *(pim[2].pb);
		pires_r++;  pires_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 70	:   /* b,i */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pb) * *(pim[2].pi) - 
			   *(pim[1].pb) * *(pim[3].pi);
		*pires_im = *(pim[0].pb) * *(pim[3].pi) +
			    *(pim[1].pb) * *(pim[2].pi);
		pires_r++;  pires_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 7	:   /* i,b */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pi) * *(pim[2].pb) - 
			   *(pim[1].pi) * *(pim[3].pb);
		*pires_im = *(pim[0].pi) * *(pim[3].pb) +
			    *(pim[1].pi) * *(pim[2].pb);
		pires_r++;  pires_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 120:   /* b,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pb) * *(pim[2].pf) - 
			   *(pim[1].pb) * *(pim[3].pf);
		*pfres_im = *(pim[0].pb) * *(pim[3].pf) +
			    *(pim[1].pb) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].pb)++;  (pim[1].pb)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
	case 12	:   /* f,b */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].pb) - 
			   *(pim[1].pf) * *(pim[3].pb);
		*pfres_im = *(pim[0].pf) * *(pim[3].pb) +
			    *(pim[1].pf) * *(pim[2].pb);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].pb)++;  (pim[3].pb)++;
	    }
	    break;
	case 33	:   /* s,s */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].ps) * *(pim[2].ps) - 
			   *(pim[1].ps) * *(pim[3].ps);
		*pires_im = *(pim[0].ps) * *(pim[3].ps) +
			    *(pim[1].ps) * *(pim[2].ps);
		pires_r++;  pires_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 73	:   /* s,i */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].ps) * *(pim[2].pi) - 
			   *(pim[1].ps) * *(pim[3].pi);
		*pires_im = *(pim[0].ps) * *(pim[3].pi) +
			    *(pim[1].ps) * *(pim[2].pi);
		pires_r++;  pires_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 37	:   /* i,s */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pi) * *(pim[2].ps) - 
			   *(pim[1].pi) * *(pim[3].ps);
		*pires_im = *(pim[0].pi) * *(pim[3].ps) +
			    *(pim[1].pi) * *(pim[2].ps);
		pires_r++;  pires_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 123:   /* s,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].ps) * *(pim[2].pf) - 
			   *(pim[1].ps) * *(pim[3].pf);
		*pfres_im = *(pim[0].ps) * *(pim[3].pf) +
			    *(pim[1].ps) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].ps)++;  (pim[1].ps)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
	case 42	:   /* f,s */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].ps) - 
			   *(pim[1].pf) * *(pim[3].ps);
		*pfres_im = *(pim[0].pf) * *(pim[3].ps) +
			    *(pim[1].pf) * *(pim[2].ps);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].ps)++;  (pim[3].ps)++;
	    }
	    break;
	case 77	:   /* i,i */
	    for (i=0; i<taille; i++){
		*pires_r = *(pim[0].pi) * *(pim[2].pi) - 
			   *(pim[1].pi) * *(pim[3].pi);
		*pires_im = *(pim[0].pi) * *(pim[3].pi) +
			    *(pim[1].pi) * *(pim[2].pi);
		pires_r++;  pires_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 127:   /* i,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pi) * *(pim[2].pf) - 
			   *(pim[1].pi) * *(pim[3].pf);
		*pfres_im = *(pim[0].pi) * *(pim[3].pf) +
			    *(pim[1].pi) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].pi)++;  (pim[1].pi)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
	case 82	:   /* f,i */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].pi) - 
			   *(pim[1].pf) * *(pim[3].pi);
		*pfres_im = *(pim[0].pf) * *(pim[3].pi) +
			    *(pim[1].pf) * *(pim[2].pi);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].pi)++;  (pim[3].pi)++;
	    }
	    break;
	case 132:   /* f,f */
	    for (i=0; i<taille; i++){
		*pfres_r = *(pim[0].pf) * *(pim[2].pf) - 
			   *(pim[1].pf) * *(pim[3].pf);
		*pfres_im = *(pim[0].pf) * *(pim[3].pf) +
			    *(pim[1].pf) * *(pim[2].pf);
		pfres_r++;  pfres_im++;
		(pim[0].pf)++;  (pim[1].pf)++;  (pim[2].pf)++;  (pim[3].pf)++;
	    }
	    break;
    }
}


/*****************************************************************************/

int
op_arithm_cte (mode, imageIn, type, colonne, ligne, cte, imageOut)
    int mode, type, colonne, ligne;
    unsigned char *imageIn;
    float cte, **imageOut;
{
    union ens_pointeur pim;
    float *pfres;
    int	code, taille;
    register int i;

    code = ouvrir (&pim, imageIn, type, 0);
    taille = ligne * colonne;

    *imageOut =  pfres = (float *) malloc (taille * sizeof(*pfres));
    switch (code){
	case 0 :    /* b+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) + cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) - cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) * cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pb) / cte;
			pfres++;  (pim.pb)++;
		    }
		    break;
	    }
	    break;
	case 3 :    /* s+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) + cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) - cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) * cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.ps) / cte;
			pfres++;  (pim.ps)++;
		    }
		    break;
	    }
	    break;
	case 7 :    /* i+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) + cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) - cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) * cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pi) / cte;
			pfres++;  (pim.pi)++;
		    }
		    break;
	    }
	    break;
	case 12:    /* f+C */
	    switch (mode){
		case 10 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) + cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
		case 11 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) - cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
		case 12 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) * cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
		case 13 : for (i=0; i<taille; i++) {
			*pfres = *(pim.pf) / cte;
			pfres++;  (pim.pf)++;
		    }
		    break;
	    }
	    break;
    }
}     



/*****************************************************************************/

int
op_arithm_cte_cmplx (imageIn1r, type1r, imageIn1i,type1i,  
		     colonne, ligne, cte, imageOutr, imageOuti)
    unsigned char *imageIn1r, *imageIn1i;
    int type1r, type1i;
    int colonne, ligne;
    struct  cte_cmplx *cte;
    unsigned char **imageOutr, **imageOuti;
{
    union ens_pointeur pim[2];
    float *pfres_r, *pfres_im, *deb_r, *deb_im;
    int	code, taille;
    register int i;
    
    /* le plan reel et imaginaire doit etre de meme type */
    code = (ouvrir (&pim[0], imageIn1r, type1r, 0) + 
	    ouvrir (&pim[1], imageIn1i, type1i, 0)) / 2;
    taille = ligne * colonne;

    pfres_r = (float *) malloc (taille * sizeof(*pfres_r));
    pfres_im = (float *) malloc (taille * sizeof(*pfres_im));
    *imageOutr = (unsigned char *) pfres_r;
    *imageOuti = (unsigned char *) pfres_im;

    switch (code){
	case 0 :    /* b+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].pb) * (cte->reel) - *(pim[1].pb) * (cte->im);
	      *pfres_im= *(pim[0].pb) * (cte->im) + *(pim[1].pb) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].pb)++;  (pim[1].pb)++;
	    }
	    break;
	case 3 :    /* s+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].ps) * (cte->reel) - *(pim[1].ps) * (cte->im);
	      *pfres_im= *(pim[0].ps) * (cte->im) + *(pim[1].ps) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].ps)++;  (pim[1].ps)++;
	    }
	    break;
	case 7 :    /* i+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].pi) * (cte->reel) - *(pim[1].pi) * (cte->im);
	      *pfres_im= *(pim[0].pi) * (cte->im) + *(pim[1].pi) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].pi)++;  (pim[1].pi)++;
	    }
	    break;
	case 12:    /* f+C */
	    for (i=0; i<taille; i++){
	      *pfres_r = *(pim[0].pf) * (cte->reel) - *(pim[1].pf) * (cte->im);
	      *pfres_im= *(pim[0].pf) * (cte->im) + *(pim[1].pf) * (cte->reel);
	      pfres_r++;  pfres_im++;  (pim[0].pf)++;  (pim[1].pf)++;
	    }
	    break;
    }
}     


