/*
 * $Header$
 *
 * $Log$
 *
 */
#include <stdio.h>
#include "sect.h"
#include "util.h"
#include "empire.h"

/* this program moves civs around a country.  it uses a dumpfile as input */
/* to describe the country and a file containing information to determine */
/* the relative value of having different numbers of people in the sectors */



/*
 * This is pmvr, a tool for automatically redistributing civs for
 * BSD-empire.  People are warned that use of this tool can devestate 
 * an empire country in a matter of a couple of updates, and so it
 * must be used carefully
 *
 * This software was written by King Craig (AKA Craig Chase) who
 * makes no warranty as to the worth or correctness of this software.
 * Use it at your own risk.
 *
 * This software may be freely distributed as long as the name(s) of
 * the author(s) remain attached.
 */



FILE *outfile, *fopen();

#define MAX_PATH_LENGTH 80


struct tpathstr {
  char path[MAX_PATH_LENGTH];
  int cost;
  int length;
  sctlst_t  *sct;
} *t_vec; /* an array of the paths to move everywhere */

int minmove = 30; /* don't bother to move civs unless going to move at 
		      least this much */

int maxpath = 10;
int maxcost = 1000;
int max_coms = 100; /* maximum number of commands which can be produced 
		       (i.e. set it low if you don't want to spend all
		       your BTUs) */


#define FALSE 0
#define TRUE 1


struct adminstr {
  int id;
  int up_weight;
  int lvl1,lvl2;
  int down_weight;
  int minmob;
};

/* country is the complete list of the whole country */
sctlst_t  *country, *read_dump();
int c_size; /* number of sectors in the country */

int optimize = FALSE; /* flag which, when set, instructs pmvr to attempt 
			 to opimize the moves it generates */

int *mov_cost; /* this pointer is used to implement the matrix of costs to 
		 move from anywhere to everywhere.  The sector id is 
		 used as the index.  The size of the matrix is 
		 c_size X c_size */
  


main(argc,argv)
int argc;
char **argv;
{
  char output_file[80];
  char dump_file[80];
  char value_file[80];
  sctlst_t  *manage;

  strcpy(output_file,"-");
  strcpy(dump_file,"dump");
  strcpy(value_file,"values");

  /* read in args */
  while(argc > 1) {
    if (argv[1][0] == '-')
      switch(argv[1][1]) {
      case 'o': /* output file arg */
	argc--; argv++;
	strcpy(output_file,argv[1]);
	break;
      case 'd': /* dump file arg */
	argc--; argv++;
	strcpy(dump_file,argv[1]);
	break;
      case 'v': /* value file arg */
	argc--; argv++;
	strcpy(value_file,argv[1]);
	break;
      case 'O': /* optimize switch */
	optimize = TRUE;
	break;
      case 'M': /* cost switch */
	argc--; argv++;
	sscanf(argv[1],"%d",&minmove);
	break;
      case 'P':
	argc--; argv++;
	sscanf(argv[1],"%d",&maxpath);
	if (maxpath > MAX_PATH_LENGTH || maxpath < 0)
	  maxpath = MAX_PATH_LENGTH;
	break;
      case 'N': /* max number of moves */
	argc--; argv++;
	sscanf(argv[1],"%d",&max_coms);
	break;
      default:
	fprintf(stderr,
		"USAGE: pmvr [-o outfile ] [-d dumpfile] [-v valuefile]\n");
	fprintf(stderr,"\t[ -O ] [-M minmove] [-P maxpath]");
	exit(1);
      }
    argc--;
    argv++;
  }
  
  if (0 == strcmp(output_file,"-"))
    outfile = stdout;
  else
    if (NULL == (outfile = fopen(output_file,"w"))) {
      fprintf(stderr,"cannot open %s for output\n",output_file);
      exit(1);
    }

  country = read_dump(dump_file);
  init_country();
  load_weights(value_file);
  admin(country);

  fclose(outfile);
}


init_country()
{
  int i;
  sctlst_t  *p;

  c_size = 0;
  for (p = country; p != NULL; p = p->next,c_size++) {
    p->spec.p = NEW(struct adminstr);
    ((struct adminstr *) p->spec.p)->id = c_size;
  }
  t_vec = NEWN(struct tpathstr, c_size);
  
  for (i = 0,p = country; i < c_size; i++, p = p->next)
    t_vec[i].sct = p;
    
#ifdef DEBUG
  fprintf(stderr,"%d sectors read from file\n",c_size);
#endif
}

/* load weights from file */
load_weights(fname)
char *fname;
{
  FILE *fp,*fopen();
  char in_line[80];
  int x,y;
  sctlst_t  *p;
  char des;
  struct adminstr * p_spec;

  if (NULL == (fp = fopen(fname,"r"))) {
    fprintf(stderr,"Cannot open %s for input\n",fname);
    exit(1);
  }

  while(NULL != fgets(in_line,80,fp)) {
    if (in_line[0] == 'S') {
      sscanf(in_line,"%*c %d,%d",&x,&y);
      for (p = country; p != NULL; p = p->next) 
	if (p->data->sct_x == x && p->data->sct_y == y) {
	  p_spec = (struct adminstr *) p->spec.p;
	  sscanf(in_line,"%*c %*d,%*d %d %d %d %d %d",
		 &p_spec->up_weight,&p_spec->lvl1,&p_spec->lvl2,
		 &p_spec->down_weight,&p_spec->minmob);
	}
    }
    else if (in_line[0] == 'C') { /* construction info */
      des = in_line[1];
      for (p = country; p != NULL; p = p->next) 
	if (((des == 'D' || p->data->sct_type == des) &&
             p->data->sct_effic < 100 )	||
            (des == 'D' && p->data->sct_newtype != '_') ||
            p->data->sct_newtype == des) {
	  p_spec = (struct adminstr *) p->spec.p;
	  sscanf(in_line+1,"%*c %d %d %d %d %d",
		 &p_spec->up_weight,&p_spec->lvl1,&p_spec->lvl2,
		 &p_spec->down_weight,&p_spec->minmob);
	}
    }
    else if (in_line[0] != ';') {
      des = in_line[0];
      for (p = country; p != NULL; p = p->next) 
	if (des == 'D' ||
            p->data->sct_type == des ||
            p->data->sct_newtype == des) {
	  p_spec = (struct adminstr *) p->spec.p;
	  sscanf(in_line,"%*c %d %d %d %d %d",
		 &p_spec->up_weight,&p_spec->lvl1,&p_spec->lvl2,
		 &p_spec->down_weight,&p_spec->minmob);
	}
    }
  }
}

value(x,src,dst,sw1,sw2,slvl1,slvl2,dw1,dw2,dlvl1,dlvl2)
int x; /* number of civs to be moved */
int src,dst; /* the number of civs already in the sectors */
int sw1,sw2,slvl1,slvl2; /* weights and thresholds for src */
int dw1,dw2,dlvl1,dlvl2; /* weights and thresholds for dst */
{
  int val;

#ifdef NOTDEFINED
fprintf(stderr,"x is %d src is %d dst is %d\n",
	x,src,dst);
fprintf(stderr,"sw1 is %d sw2 is %d slvl1 is %d slvl2 is %d\n",
	sw1,sw2,slvl1,slvl2);
fprintf(stderr,"dw1 is %d dw2 is %d dlvl1 is %d dlvl2 is %d\n",
	dw1,dw2,dlvl1,dlvl2);
#endif  


  val = 0;
  if (src > slvl2)
    if (src - x < slvl2)
      val += sw2 * (src-slvl2);
    else
      val += sw2 * x;
  if (src - x < slvl1)
    if (src > slvl1)
      val -= sw1 * (slvl1 - (src - x));
    else
      val -= sw1 * x;
  if (dst + x > dlvl2) {
    if (dst > dlvl2)
      val -= dw2 * x;
    else
      val -= dw2 * (dst + x - dlvl2);
  }
  if (dst < dlvl1) {
    if (dst + x < dlvl1)
      val += dw1 * x;
    else
      val += dw1 * (dlvl1 - dst);
  }
#ifdef NOTDEFINED
  fprintf(stderr,"moving %d civs has %d value\n",x,val);
#endif 
  return val;
}


/* find the optimum number of civs to move from src to dst */
/* it is assumed that mintree has already be run to compute costs for */
/* moving into dst */
find_good_move(src,dst,p_val,p_num,cost)
sctlst_t  *src,*dst; 
int *p_val; /* incremental value of making this move */
int *p_num; /* number of civs which should be moved */
int cost; /* the cost of moving 500 civs into this sector */
{
  int lbound,ubound; /* upper and lower bounds of civs to move */
  int max_to_mov;
  int val;
  int moving; /* the number of civs being considered to move */
  int src_civs,dst_civs;
  int slvl1,slvl2;
  int dlvl1,dlvl2;
  int sw1,sw2;
  int dw1,dw2;
  struct adminstr *s_spec,*d_spec;
  float mob_points; /* number of mobility points it costs to move 1 civ */
   
  *p_val = *p_num = 0;

  if (src->data->sct_loyal == '*' || dst->data->sct_loyal == '*')
    return;

  s_spec = (struct adminstr *)src->spec.p;

  if (cost == 0)
     max_to_mov = src->data->coms[CIV];
  else
     max_to_mov = (500 * (src->data->sct_mobil - s_spec->minmob)) / cost;

  /* watch out! you gotta make sure you don't overload a sector
    and get "Too much traffic" errors!!!!!! */
  if (dst->data->coms[CIV] < 10)
    max_to_mov = MIN(max_to_mov, 100);

  ubound = MIN(src->data->coms[CIV]-1,max_to_mov);
  lbound = minmove;

  src_civs = src->data->coms[CIV];
  s_spec = (struct adminstr *)src->spec.p;
  slvl1 = s_spec->lvl1;
  slvl2 = s_spec->lvl2;
  sw1 = s_spec->up_weight;
  sw2 = s_spec->down_weight;

  dst_civs = dst->data->coms[CIV];
  d_spec = (struct adminstr *)dst->spec.p;
  dlvl1 = d_spec->lvl1;
  dlvl2 = d_spec->lvl2;
  dw1 = d_spec->up_weight;
  dw2 = d_spec->down_weight;

  mob_points = ((float) cost) / 500;
  if (ubound > lbound) {
    /* check at lbound */
    val = value(lbound,src_civs,dst_civs,sw1,sw2,slvl1,slvl2,
		dw1,dw2,dlvl1,dlvl2);
    if (val > *p_val) {
      *p_val = val;
      *p_num = lbound;
    }

    /* check at ubound */
    val = value(ubound,src_civs,dst_civs,sw1,sw2,slvl1,slvl2,
		dw1,dw2,dlvl1,dlvl2);
    if (val > *p_val) {
      *p_val = val;
      *p_num = ubound;
    }

    /* check at slvl1 */
    if (src_civs > slvl1 && src_civs - ubound < slvl1) {
      moving = src_civs - slvl1;
      if (moving > lbound) {
	val = value(moving,src_civs,dst_civs,sw1,sw2,slvl1,slvl2,
		    dw1,dw2,dlvl1,dlvl2);
	if (val > *p_val) {
	  *p_val = val;
	  *p_num = moving;
	}
      }
    }

    /* check at slvl2 */
    if (src_civs > slvl2 && src_civs - ubound < slvl2) {
      moving = src_civs - slvl2;
      if (moving > lbound) {
	val = value(moving,src_civs,dst_civs,sw1,sw2,slvl1,slvl2,
		    dw1,dw2,dlvl1,dlvl2);
	if (val > *p_val) {
	  *p_val = val;
	  *p_num = moving;
	}
      }
    }

    /* check at dlvl1 */
    if (dst_civs < dlvl1 && dst_civs + ubound > dlvl1) {
      moving = dlvl1 - dst_civs;
      if (moving > lbound) {
	val = value(moving,src_civs,dst_civs,sw1,sw2,slvl1,slvl2,
		    dw1,dw2,dlvl1,dlvl2);
	if (val > *p_val) {
	  *p_val = val;
	  *p_num = moving;
	}
      }
    }

    /* check at dlvl2 */
    if (dst_civs < dlvl2 && dst_civs + ubound > dlvl2) {
      moving = dlvl2 - dst_civs;
      if (moving > lbound) {
	val = value(moving,src_civs,dst_civs,sw1,sw2,slvl1,slvl2,
		    dw1,dw2,dlvl1,dlvl2);
	if (val > *p_val) {
	  *p_val = val;
	  *p_num = moving;
	}
      }
    }
  }
}



/* compute the best path to move civs from s to d, and generate the */
/* mov command to do so.  */
/* Update the sector data for civ population and mob points */
mov_em(s,d,num)
sctlst_t  *s,*d;
int num;
{
  int d_id; 
  
  make_tree(s);
  d_id = ((struct adminstr *)d->spec.p)->id;

#ifdef DEBUG
  if (t_vec[d_id].cost < 0) {
    fprintf(stderr,"SHIT!!!!! I'm trying to do the impossible!\n");
    fprintf(stderr,"trying to move from %d,%d to %d,%d\n",
	    s->data->sct_x,s->data->sct_y,d->data->sct_x,d->data->sct_y);
  }
  else {
    fprintf(stderr,"trying to move from %d,%d to %d,%d\n",
	    s->data->sct_x,s->data->sct_y,d->data->sct_x,d->data->sct_y);
  }

#endif

  fprintf(outfile,"mov civ %d,%d %d v%sv\n",s->data->sct_x,s->data->sct_y,
	  num,t_vec[d_id].path);
  fprintf(outfile,"h\n");

  s->data->sct_mobil -= (int) (0.9999 + 
			       num * ((float) t_vec[d_id].cost) / 500 );
  s->data->coms[CIV] -= num;
  d->data->coms[CIV] += num;
}





/* decide who do move where */
admin(lst)
sctlst_t  *lst;
{
  sctlst_t  *best_src;
  sctlst_t  *best_dst;
  int best_num_civs;
  int best_value; /* the maximum incremental value found so far */
  int value,num_civs;
  int s_id,d_id;
  int movs = 0; /* number of mov commands generated so far */
  int *cost; /* a pointer int the mov cost array should always be
	       such that *cost <==> mov_cost[s_id][d_id] */
  
  find_paths();

  do {
    best_value = 0;
    /* for each sector src in list */
    cost = mov_cost;
    for (s_id = 0; s_id < c_size; ++s_id) {
      if (!optimize)
	best_value = 0;

      for (d_id = 0; d_id < c_size; d_id++,cost++) {
	if (d_id != s_id && *cost >= 0 ) {
	  find_good_move(t_vec[s_id].sct,t_vec[d_id].sct,
			 &value,&num_civs,*cost);
	  if (value > best_value) {
	    best_value = value;
	    best_src = t_vec[s_id].sct;
	    best_dst = t_vec[d_id].sct;
	    best_num_civs = num_civs;
	  }
	}
      }
      if (!optimize && best_value >0) 
	mov_em(best_src,best_dst,best_num_civs);
    }
    if (optimize && best_value > 0) {
#ifdef DEBUG
      fprintf(outfile,"moving %d civs from %d,%d to %d,%d\tvalue %d\n",
	      best_num_civs,
	      best_src->data->sct_x,best_src->data->sct_y,
	      best_dst->data->sct_x,best_dst->data->sct_y,
	      best_value);
#endif
      mov_em(best_src,best_dst,best_num_civs);
      movs++;
    }
  } while (best_value > 0 && movs < max_coms);
}

/* find good paths between every pair of sectors in the country */
/* for storage reasons, only the cost is recorded for moving between */
/* the sectors */
find_paths()
{
  sctlst_t  *src;
  int s_id; /* the id of the source sector */
  int i,j;
  int *ptr;


  mov_cost = NEWN(int, c_size * c_size);

  /* it is assumed that the list pointed to by 'country' is ordered
     by id nums */

  for (src = country; src != NULL; src = src->next) {
    make_tree(src);
    s_id = ((struct adminstr *) src->spec.p)->id;
    ptr = mov_cost + s_id * c_size;
    for (i = 0; i < c_size; i++) 
      *ptr++ = t_vec[i].cost;
  }
}


/* set the t_vec array to hold paths from the root node for all sectors */
/* whose ids are greater than that of the root */
make_tree(root)
sctlst_t  *root; /* a point on the tree */
{
  int root_id;
  int s_id,d_id;
  int i;
  int thislength;
  int thiscost;
  sctlst_t  *todo; /* the list of sectors to visit */
  sctlst_t  *tail; /* the last sector in the todo list */
  static char pathdir[7]="yujnbg";
  char incpath[2]; /* incremental path */
  struct sctstr *sct;

  root_id = ((struct adminstr *) root->spec.p)->id;
  /* initialize the tree */
  for (i = 0; i < c_size; i++) {
    t_vec[i].cost = -1;
    t_vec[i].length = -1;
    strcpy(t_vec[i].path,"");
  }
  t_vec[root_id].cost = 0;
  t_vec[root_id].length = 0;
  strcpy(t_vec[root_id].path,"");

  /* make the root node the only thing on the tree */
  root->aux = NULL;
  todo = root;
  tail = root;
  
  /* build the tree */
  for (; todo != NULL; todo = todo->aux) {
    s_id = ((struct adminstr *) todo->spec.p)->id;
    thislength = t_vec[s_id].length + 1;
    if (thislength <= maxpath) {
      for (i = 0; i < 6; i++) {
	if (todo->neighbor[i] != NULL) {
	  d_id = ((struct adminstr *)todo->neighbor[i]->spec.p)->id;
	  sct = todo->neighbor[i]->data;
	  thiscost = t_vec[s_id].cost + COST(sct);
	  if (thiscost < maxcost) {
	    if (t_vec[d_id].cost < 0) {
	      /* add it to the tree and put it on the todo list */
	      t_vec[d_id].cost = thiscost;
	      t_vec[d_id].length = thislength;
	      incpath[0] = pathdir[i];
	      incpath[1] = '\0';
	      strcpy(t_vec[d_id].path,t_vec[s_id].path);
	      strcat(t_vec[d_id].path,incpath);
	      tail->aux = todo->neighbor[i];
	      todo->neighbor[i]->aux = NULL;
	      tail = todo->neighbor[i];
	    }
	    else if (t_vec[d_id].cost > thiscost ||
		     (t_vec[d_id].cost == thiscost && 
		      t_vec[d_id].length > thislength)) {
	      /* we've found a better path, make it so */
	      t_vec[d_id].cost = thiscost;
	      t_vec[d_id].length = thislength;
	      incpath[0] = pathdir[i];
	      incpath[1] = '\0';
	      strcpy(t_vec[d_id].path,t_vec[s_id].path);
	      strcat(t_vec[d_id].path,incpath);
	    }
	  }
	}
      }
    }
  }
}

	
      
      

  
