;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Emacs-Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;
;; emp-install.el -- Top level release notes and installation for empire
;; 
;; Copyright (c) 1990 Lynn Randolph Slater, Jr
;; 
;; Author          : Lynn Slater (lrs@indetech.com)
;; Created On      : Fri Oct 26 14:30:03 1990
;; Last Modified By: Lynn Slater x2048
;; Last Modified On: Thu Feb 14 19:16:29 1991
;; Update Count    : 127
;; Status          : GEET General Release 2d Patch 0
;; 
;; PURPOSE
;; 	This file contains "how-to" instructions both for installation and
;; maintenance of empire but also for how to use the tool to play the game.
;;
;; Code writers hints are also provided.
;; 
;; HISTORY
;; 4-Feb-1991		Lynn Slater x2048	
;;    Last Modified: Mon Feb  4 11:42:16 1991 #121 (Lynn Slater x2048)
;;    options are displayed and edited in execution order
;;    plane-checks and adjust are now editable hooks
;; 4-Feb-1991		Lynn Slater x2048	
;;    Last Modified: Mon Feb  4 11:40:36 1991 #120 (Lynn Slater x2048)
;;    changed empire-pos to have resource. Added convert-empire-pos.
;; 31-Jan-1991		Lynn Slater x2048	
;;    Last Modified: Thu Jan 31 09:52:24 1991 #115 (Lynn Slater x2048)
;;    split part of emp-modes and emp-shell into emp-mouse, emp-buffers,
;;    and emp-cmds
;; 25-Jan-1991		Lynn Slater x2048	
;;    Last Modified: Fri Jan 25 11:35:11 1991 #110 (Lynn Slater x2048)
;;    split out emp-const
;; 22-Jan-1991		Lynn Slater x2048	
;;    Last Modified: Mon Jan 21 20:29:42 1991 #108 (Lynn Slater x2048)
;;    added emp-nsc per Robert Forsman, added Ken's changes.
;; 21-Jan-1991		Lynn Slater x2048	
;;    Last Modified: Mon Jan  7 20:27:33 1991 #106 (Lynn Slater x2048)
;;    added plane capabilities from Ken Stevens <stevens@hplabs.hp.com>
;; 7-Jan-1991		Lynn Slater x2048	
;;    Last Modified: Sat Jan  5 13:43:58 1991 #102 (Lynn Slater x2048)
;;    added emp-sail
;; 5-Jan-1991		Lynn Slater x2048	
;;    Last Modified: Mon Dec 17 11:21:09 1990 #101 (Lynn Slater x2048)
;;    added emp-ship as a file. Thansk to Robert Forsman
;; 30-Nov-1990		Lynn Slater x2048	
;;    Last Modified: Fri Nov 30 10:02:43 1990 #83 (Lynn Slater x2048)
;;    more troubleshooting. More files.
;; 4-Nov-1990		Lynn Slater	
;;    Last Modified: Fri Nov  2 19:33:07 1990 #34 (Lynn Slater)
;;    added empire-filesp. Added -l ~/.emacs to compile shell line
;; TABLE OF CONTENTS
;;   empire-filesp -- Shows if all the empire files exist. Is good for debugging the installation.
;;   reload-empire -- Loads fresh copies of all empire code
;;   compile-empire -- Compiles all known empire files
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The contents of this file ARE copyrighted but permission to use, modify,
;; and distribute this code is granted as described later in this file.
;; These terms constitute what the Free Software Foundation calls a COPYLEFT.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Usage Justification -- Why use Gnu Emacs Empire Tool
;;   It runs from many terminals giving you an multi window interface
;;     even from dumb boxes. You can play smart from home.
;;   The consistency check rules are as a set the best available to date.
;;     according to 1 user, "the starvation predictor ALONE is worth its
;;     weight in gold!"  
;;   You can change the rules very easily.
;;   You can change them NOW!
;;     I.e. big mean joe's awesome armada just appeared on your west coast
;;	 radars -- quick -- alter the ideal-mil fcn to favor the west coast
;;	 and redistribute-mil. Big mean joe will find poor pickings.
;;   The integrated map, cross session sector memory, and low cost path calc
;;     make the game much easier to play.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Proposed Ethics (unenforcable)
;;
;; Use this freely, make changes, use them to clobber at most ONE world,
;; and then send in the changes. Think of this as a cross-universe tech
;; leak and as an incentive to always make better stuff because eventually
;; your opponents will have what you have. Tech leaks of this sort will also
;; help evolve empire into something 
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Installation Instructions
;;   save each of the empire files somewhere in the emacs-path. If you
;;   cannot write to the default load-path, use a line such as the
;;   following in your .emacs file in your home:
;;     (setq load-path (cons "$HOME/mydir/thisplace" load-path))
;;                                                           ^
;;     Type \C-xe here to enable in current emacs.           ^
;;     Note that "~" is not expanded in load paths.
;;   In a shell
;;     emacs -batch -l ~/.emacs -l emp-install -f compile-empire
;;   If you get a message such as
;;     Cannot open load file: emp-option
;;   see the section below on TROUBLESHOOTING.
;;     
;;   !!! Follow directions in x-misc.el if you want X support. !!!
;;   
;;   Place the following in .emacs or the site-init.el file
;;	(autoload 'empire-shell "empire"
;;		  "Starts empire mode."
;;		  t)
;;     To enable, eval the above line (type \C-x\C-e at the end) or reenter
;;     emacs. 
;;   If you want the empire commands not under C-c, also insert a line such as
;;     (setq empire-shell-special-key "\C-e")
;;
;;   To play, type
;;     M-x empire-shell
;;   You will be in *Empire* buffer. Type to the shell
;;	   emp_client
;;
;;   Later in this file will be how to play instructions.
;;   
;;   Be sure to walk through each customization options from the empire
;;   shell buffer as alot of the tool's power is shown in some of the
;;   explinations. 
;;
;;   The instructions given presume basic emacs familarity and no explination
;;   will be given of buffer or window selection or access to the help system.
;;   Refer to the emacs users guide for these features.
;;
;; Troubleshooting help is later in this file.
;; Batch play is documented in empire-batch
;; 
;; ----------------------------- Mail Lists ----------------------------------
;; There are three mail lists related to gnu emacs empire
;;   announcements only  
;;     gnurus-announce@indetech.com
;;     gnurus-announce-request@indetech.com
;;   discussion, bug fixes,  and announcements
;;     gnurus-info@indetech.com
;;     gnurus-info-request@indetech.com
;;   bug reports, discussion, and announcements
;;     gnurus-bugs@indetech.com
;;     gnurus-bugs-request@indetech.com
;;  
;; If you did not recieve your copy directly from Lynn Slater, write
;; to one of the -requests lists to be added. This is strongly advised as
;; you will miss the updates and problem fixes otherwise.
;; 
;; Mail into any of these lists automatically forwards to all subscribers.
;; Be careful not to jabber but have fun talking with other users.
;  Send problem mail to the bugs list, send items of general interest to the
;; info list. (You must decide if a problem merits the time of all the folks
;; on the info list -- the reply will go to that list in any case.) If the
;; bug list does not get an answer to you (maybe we are all busy), try the
;; info list. 
;;
;; All are invited to be on the bugs list as alot of mail there will be
;; questions many can answer. The only reason to be on one of the other
;; lists instead is mail volume. 
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Troubleshooting:
;; 
;; THE LOAD PATH PROBLEM
;; > Sorry to bother you with such a trivial problem, but I'm having
;; > trouble getting this thing to compile.  I type the compile command in
;; > install, but I get the error "Cannot open load file: emp-option."  Can
;; > anyone help with this?
;; 
;; Thanks for addressing this to gnurus-bugs -- you are more likely to get quick
;; help that way. This time, I just happen to be the first responder.
;; 
;; This is "THE LOAD PATH PROBLEM" -- the file (which happens to be the first
;; 'required file) is not found. Do a M-x describe-variable on load-path to
;; see what the path is when you run interactively.  You should also see 
;; messages such as the following:
;; > File	emp-install.el	does     exist.
;; > File	emp-option.el	does     exist.
;; > File	emp-db.el	does     exist.
;; > File	emp-help.el	does     exist.
;; > File	emp-anal.el	does     exist.
;; > File	emp-shell.el	does     exist.
;; > File	emp-float.el	does     exist.
;; > File	emp-sector.el	does     exist.
;; > File	emp-auto.el	does     exist.
;; > File	emp-modes.el	does     exist.
;; > File	empire.el	does     exist.
;; > 
;; > Load path is ("/export/share/gnu/local/lisp" "/export/share/gnu/contrib/lisp" "/export/share/gnu/dist/emacs-18.52/lisp")
;; 
;; If any file does NOT exist you are not cd'ing to the correct place. If this
;; does not fix your problem and the current directpory is not listed on the
;; load-path line, then edit the .emacs file to have a line such as the
;; following 
;;      (setq load-path (cons "$HOME/mydir/thisplace" load-path))
;; and try again. If you do NOT see the current dir on the load path, you have
;; messed up the edit or the .emacs file is failing and you gotta fix that
;; before proceeding.  Do NOT use "~" notation in the load path -- it is
;; not expanded. 
;; 
;; If nothing works, here is the fallback:
;;   Start emacs the usual way
;;   M-x load-library emp-install
;;   M-x compile-empire
;;
;; If you compile of but get the error "cannot open load file ..."
;; interactively, check that you have evaluated the load path setq (via
;; \C-xe) since it was last changed if you changed it in the current
;; session. If you beleive that it has been evaluated, try M-x
;; describe-variable load-path and verify that emp-db.elc REALLY exists in
;; one of the listed directories. In all cases of this error so far, the
;; fiels did not exist in the load-path. Correct the load path or the
;; files. 
;; 
;; Compilation errors:
;;   If you see the message: Symbol's value as variable is void: empire-pos
;;   you did not M-x load-file <cr> empire.el. The load is needed to define
;;   variables that are used by macros to fix in array offsets at compile
;;   time.
;;   
;; Bogus sector data --- all sorts of odd errors during dump scans or checks
;;   The order of labels in the empire-pos array MUST match that of the
;;   dump command. 
;;   If sectors are bad or logs of "wrong type" errors appear, check this
;;   list because an error here will mess up the entire sector state
;;   storage scheme.
;;
;;   For speed, the code compiles in the values from empire-pos -- so if
;;   you change it, you MUST recompile empire. Those doing alot of
;;   changing, or those who want custom empire-pos arrays may want to
;;   replace the body of position-of with the body of dynamic-position-of;
;;   the latter does run time lookups based on a variable that is saved
;;   along with the sector data.
;;
;;   Dietys: Note that this tool is not particularly useful to the diety as
;;   the diety should not be doing much and certainly will not need dist,
;;   level, thresh, and related rules. Consequently, I have not used it as
;;   a diety and it will probably break. At the minimum, you will have to
;;   fiddle the empire-pos list because you see more in the dump command
;;   than do other folks. In particular, you must at least move 'own to the
;;   start of this list.
;;   
;; The "wrong type arg integer-or-markerp nil" error
;;   > a related problem to the mis-matched realm seems to be when your country
;;   > no longer includes (0,0).
;;   
;;   You will get the above error if you try to do an analyze on a sector whose
;;   dump command output has never been scanned. This error is basically
;;   complaining that an arithemetic operation was done on a non-existant value.
;;   (This is kind of like strlen(0) in C.)
;;   
;;   If this error is happening, lookover realm 0 very carefully. Your whole
;;   country does not HAVE to be in realm 0 but if it is not you will have to do
;;   more manual fiddles than most will be confortable with.  You have to at
;;   least dump and scan each sector once. You do not have to dump it after
;;   that, but if you do not, the suggestion will always be based on old data.
;;   
;; ^M's in the shell:
;;   This is most often because of how an rsh or rlogin worked with the
;;   term type "emacs". you can do a stty in a "good" shell, grab the
;;   output, and use it in the empire shell. I.E> on my boxes when I rsh to
;;   play empire (because we did not compile the client onto all
;;   archetectures), I do the following:
;;     rsh <machine>
;;     stty -inpck -icrnl imaxbel -onlcr -echo -echoprt -echoctl
;;     emp_client ...
;;   Note that some shells, like tcsh, do not permit stty to change much.
;;   In this case, setenv ESHELL /bin/csh.
;;
;; Performance hit on dist route finding
;;   > I'm still having trouble where `find-dist-pts' takes *FOREVER* if your
;;   > country has any large area of roads (undeveloped sectors).
;;   This is due to exponential growth of number of routes to explore. A
;;   bunch of sectors that are all roads is not such a good idea and should
;;   be redesignated anyway.
;;
;; Data does not scan
;;   The data scan is by a series of regular expressions, many of which
;;   presume case insensitivity.  Try (setq case-fold-search t) if you
;;   suspect your emacs shell is case sensitive.
;;
;;   Most scan errors are a problem with a regular expression relative the
;;   the version of the empire server being run. You can twiddle the
;;   regular expresions yourself or you can send in the command and its
;;   output to the bugs list. These are relatively simple to fix and you
;;   will likely get a quick response.
;;   
;; Which emacs version
;;   > What verions of emacs are you using.  I noticed that it would
;;   > not run under 18.51.  It seems to run fine under 18.55.
;;   
;;   Most any emacs from 18.48 onward should basically work but there has been
;;   no attempt to test this. I do know that 18.52 and 18.55 work.  If you
;;   describe what is failing, odds are that I can suggest a load or so that
;;   will get you going.
;;
;; "Lisp exceeds max-lisp-eval-depth" error:
;; "Variable binding depth exceeds max-specpdl-size" error:
;;   The road walkers and path finders have walked so far that emacs thinks
;;   you have unlimited recursion and stops it. This normally only happens
;;   on large countries on large land masses. To fix,
;;     (setq max-lisp-eval-depth 400)
;;   or
;;     (setq max-specpdl-size 600)
;;   in .emacs file. Type \C-x\C-e    ^ here for immediate effect. Large
;;   countries may have to try even larger setings.
;;
;;   Another fix for many of these problems is to not push the road walkers
;;   quite so far. Use \C-cuv and edit
;;     empire-highway-min-eff,
;;     empire-route-past-bridges,
;;   and
;;     empire-use-inefficient-highways
;;   Users of release 2.c Patch 3 or better can set empire-max-path-depth
;;     to limit their road walking.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Sending for help:
;;  General:
;;    If you ever get an unexpected error from emacs, you can
;;      (setq debug-on-error t)
;;    and when you recreate the error the *Backtrace* buffer will appear.
;;    Mail 
;;      1) As clear a description of problem as is possible.
;;      2) The shell buffer
;;      3) The *Backtrace* buffer
;;      4) The *World Diagnoses* buffer after doing M-x empire-test-world-setup
;;      5) The empire save file (optional in some cases)
;;
;;    to the bugs list (gnurus-bugs@indetech.com) and I or others will most
;;    likely solve the problem. In the meantime, type "q" in the buffer to
;;    make it go away and 
;;      (setq debug-on-error nil)
;;    to disable the tracing.  Continue playing as lisp is quite robust and
;;    you may have only lost an isolated feature.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Installation and compilation Support code
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defvar empire-files nil
  "The list of known empire files in the order they are to be compiled")
(setq empire-files '(
		     "emp-install.el"
		     "emp-option.elc"
		     "emp-const.elc"
		     "emp-db.elc"
		     "emp-ship.elc"
		     "emp-help.elc"
		     "emp-shell.elc"
		     "emp-buffers.elc"

		     "emp-anal.elc"

		     "emp-float.elc"
		     "emp-sector.elc"
		     "emp-dev.elc"

		     "emp-sail.elc"
		     "emp-plane.elc"

		     "emp-auto.elc"

		     "emp-mouse.elc"
		     "emp-cmds.elc"
		     "emp-modes.elc"

		     "emp-nsc.elc"
		     "emp-survey.elc"

		     "emp-batch.elc"
		     "empire.el"
		     "empire.doc"
		     "empire-batch"   ; Runs a batch job
		     "empire.crontab" ; Schedules when to run jobs
		     ))
  
(defun empire-filesp ()
  "Shows if all the empire files exist. Is good for debugging the installation."
  (interactive)
  (with-output-to-temp-buffer "*Files*"
    (princ (format "load-path is %s\n\n" load-path))
    (mapcar
     '(lambda (file)
	(if (string-match "\\.elc" file)
	    (setq file  (substring file 0 (1- (length file)))))
	(if (string-match "\\.el" file)
	    (progn
	      (princ (message "File\t%s\tdoes %s exist." file
			      (if (file-exists-p file) "   " "NOT")
			      ))
	      (terpri)
	      (file-exists-p file))))
     empire-files)))

(defun reload-empire ()
  "Loads fresh copies of all empire code"
  (interactive)
  ;; Now, load them in order
  (mapcar '(lambda (file)
	     (if (and (string-match "\\.elc" file)
		      (not (string-match "batch" file)))
		 (load-library (substring file 0 (string-match "\\.elc" file)))))
	  empire-files))

(defun compile-empire ()
  "Compiles all known empire files"
  ;; This technique of compiling via command makes installation easier.
  ;; Using this from the command line proves that the compilation is
  ;;   recreatable without already having the previous empire macro defns
  ;;   loaded. It also isolates the compile from any transisent or
  ;;   accidental changes in variable or constant values.
  (interactive)
  (empire-filesp)
  (message "Load path is %s" load-path)
  (message "Default current directory is %s" default-directory)
  (mapcar '(lambda (file)
	     (if (string-match "\\.elc" file)
		 (progn
		   ;; get macros first
		   (load-file (substring file 0 (1- (length file))))
		   ;; now compile
		   (byte-compile-file (substring file 0 (1- (length file)))))))
	  empire-files)
  (message "")
  (message "Load all the new empire stuff to prove it can be done")
  (reload-empire)
  ;;
  ;; Reload `debug.el' to undo the damage done by having `emp-batch.elc'
  ;; loaded by `load-file' in the `mapcar' above.
  ;;
  (load-library "debug")
  )

(defun update-empire-file-status (new-status)
  (interactive "sNew Status: ")
  (mapcar '(lambda (file)
	     (if (string-match "\\.elc" file)
		 (setq file  (substring file 0 (1- (length file)))))
	     (find-file file)
	     (beginning-of-buffer)
	     (if (re-search-forward " Status[ \t]*:[ \t]" nil t)
		 (progn
		   (kill-line nil)
		   (insert new-status)
		   (update-table-of-contents)
		   )))
	  empire-files)
  )



;;
;;			 *** What is the tool? ***
;;
;;Gnu emacs empire tool is an intervace to the BSD empire game. It comes
;;supplied with a sector database, a empire shell interaction mode, a map
;;(reflecting the sector database), and a series of analysis tools (each
;;printing to a different buffer) which will maintain much of the economic
;;state of the country.  
;;
;;The empire shell is a buffer in a variant of shell mode.  From here you can
;;type commands to the client and see the replies. Except for the normal
;;shell mode resend of previous commands capabilities, not much has been
;;gained just from the shell mode.
;;
;;  Attached to the shell under C-c are a series of empire commands. (The
;;  shell commands that are normally under C-c in a shell are under C-cC-s.)
;;  In this map are commands to save and restore the sector database, to
;;  check the country or the air defense readyness, do a commodity flow
;;  analysis (very useful), refresh the map, etc. There are also commands to
;;  insert the coordinates of the point from the map, to find a high
;;  efficiency road path to the last mentioned sector, or to change the
;;  current sector on the map.
;;
;;  A real important command from the shell or any empire buffer is tab; this
;;  starts a menu of shell interaction commands that correspond to game
;;  commands and which also cause auto scanning. commands under here are
;;  move, cen, rad, sat, nav, look, etc.
;;
;;  Also attached under C-c are a series of special submenus:
;;    C-cx starts a series of extraction commands,
;;    C-cd starts div, mil, and food redistribution commands,
;;    C-cu starts a series of commands to customize the tool, and
;;    C-co starts a series of special use commands
;;
;;  Under the extraction commands are a series of special purpose extractions
;;  that get the next spy, radar, look, etc. These can be used if you have a
;;  particular thing you want extracted that the tool missed but for the most
;;  part do not need to be used.  Also under the map is a command to extract
;;  everything to the end of the buffer -- this can be handy. However, the
;;  most useful commands are the ones that talk to the shell and extract on
;;  the fly. These issue map, dump, prod, rad, sat, etc and scan the outputs to
;;  load the sector database. What this cannot do is extract "one shot"
;;  information such as the radar output from a ship that since moved -- for
;;  this directed scanning from the buffer is needed. Generally this can be
;;  done once every few playing hours. (I just place the cursor at the top
;;  and start the do everything command) 
;;
;;  From the map mode are a also series of commands that talk to the shell and
;;  extract the results; these will be introduced later.
;;
;;  From the distribution submenu there are commands that move civilians from
;;  efficient overpopulated sectors to inefficent sectors (other rules cause
;;  food to be in these sectors -- the rules osculate moving civs and food so
;;  that a steady growth rate is maintained), spread mil around according to
;;  sector type and nearby threats, move people from 999 civ sectors to
;;  anywhere that can take them (so you grow tfast), and spread food over
;;  roadways to the "useless" mobility on roads can be used to pump
;;  warehouses full.
;;
;;  Under the customization menu are commands to change the analysis hooks
;;  used to check the country or read a dump. You can also set any of a large
;;  number of thresholds and min value user variables or change the portion
;;  of the world's map that will be displayed and checked. 
;;
;;  Under the "other" menu is some very strange and interesting stuff.
;;  Commands there will grab all the land on an island and designate it,
;;  break sanctuary and race for land, expand your country by 1 sector in any
;;  direction, nova and supernova (you gotta try these!), and take load off a
;;  distribution point by offering commands that will distribute them
;;  elsewhere. 
;;
;;The map buffer displays the sector designations of any sector you have ever
;;seen; it displays sector data as you move the point around. From here you
;;can also issue interaction commands (either through tab or by capitalized
;;keys), send paths to the shell, or cause auto path calculation and
;;insertion. Most C-c commands are also available. A detailed explination of
;;this buffer will be given later.
;;
;;The data buffers each hold the results of some analysis.  Sugestions which
;;are ready to execute empire commands will appear in the first column and
;;may be executed by using \C-cx on that line. Other lines are things to
;;consider or else things the tool is not smart enough to solve on its own.
;;Other commands show on the map the first sector mentioned on the line or
;;move to the map or command buffer.  Detals of these buffers are given later.

;;		 *** How to Get Started Using the Tool ***
;;1. Get the Code loaded:
;;   Either use the autoload mentioned above, or
;;     M-x load-library empire
;;
;;2. Get a empire shell
;;   Easy Way:
;;     M-x empire-shell
;;
;;   Hard Way: 
;;     Start an emacs shell via M-x shell or any other favorate trick
;;     Type M-x empire-shell-mode to get it into the empire shell variant
;;
;;   After doing it either way: 
;;     run emp_client
;;
;;     If you must rsh, that is ok but you may need to do a stty on the other
;;     side. (This is because many machines do not have a termtype "emacs".)
;;     I typically go to a normal shell, type stty, kill-region the 1 or two
;;     lines that it prints, switch to the *Empire* shell, yank them back in,
;;     merge them, and place a stty on front to get something like the below:
;;       stty -inpck -icrnl imaxbel -onlcr -echo -echoprt -echoctl
;;
;;3. Recover your universe or teach the tool a new universe
;;
;;   The tool stores a sector database with some of the information known to
;;   the client and without forgets. (If you have seen it once, it will be
;;   preserved until reset. old data is better than no data.) For
;;   performance reasons, emacs does not automatically parse all things returned
;;   from empire -- instead, you must occasionally tell it when to scan. In
;;   practice, this is not a problem.
;;
;;   This release (2.x) differs greatly from the 1.x releases in that the
;;   tool will cary out a dialog with the shell and eliminate much of the
;;   manual scanning starts needed in 1.x.
;;
;;   In the examples below, items on lines starting with 'Command: ' are empire
;;   commands. 
;;
;;    *** First use of emacs on an established world ***
;;    Set realm 0 to be larger than your country but not too large.
;;    -32:32,-32:32 is the max size I would suggest for most countries.
;;    
;;    M-x empire-get-new-world will start a dialog with the client that will
;;    initialize the sector database. You will be asked for the tools'
;;    bounds; these are used so that the tool does not spend forever scanning
;;    parts of the world unknown and instead focusses on your segments.
;;
;;    (If you have saved old empire sessions, read them via find-file and run
;;    M-x empire-read-data (\\[empire-read-data]) on each one. Alternatively,
;;    move them into a single dir, read the dir with emacs, and run
;;    '\\[dired-empire]' Be sure to read data from a new session last because
;;    the last data read will be the data stored in the emacs sector data store.)
;;
;;    You will have the *Dump* and *Check* buffers with suggested actions
;;    (see below). Other actions will result from analysys commands you may
;;    issue later. You will also have the *Map* buffer from which much of the
;;    game will be played.
;;
;;    You may new-world even from an existing sector db -- just supply a
;;    different file name.
;;
;;    The tool works best for some in a tri-split screen nmode with one
;;    screen generally being the map, one the shell, and one changing from
;;    buffer to buffer. One way to get this is to evaluate the following form
;;    after doing a C-x 1
;;      (setq split-height-threshold (1+ (/ (window-height) 3)))
;;    or
;;      (setq split-height-threshold (1- (/ (window-height) 2)))
;;
;;    *** First use of emacs on an new world ***
;;    Maybe you are not an empire expert, or maybe you do not feel like the
;;    tedium of grabing land near you. If you are in a game where massive
;;    initial land grab is more important than preserving mobility, and you
;;    have not yet broken sanctuary, try 
;;       M-x empire-break-new-world
;;    This will break and explore all around you until there is no mob left
;;    on both initial sectors. On one hand, you gets lots of land fast but on
;;    the other hand maybe that mobility would be better used another way.
;;    
;;    Right after this, get the land designations correct. Get an ag center
;;    up near the capital so that you will have food to grow and get roads
;;    near the capital and ag center so you can move out well. Lay out a basic
;;    road strategy (or warehouse strategy if you follow Scott Yelish's
;;    scheme). Get the designations basically correct early in the game as
;;    the tool will automatically cause growth and can cause a porly
;;    designated sector to be built as somethoing worthless.
;;
;;    If you want some control over the mobility consumed, you can still use
;;    the nova and supernova commands (\C-co? from the shell) to grab land.
;;
;;4. Customize the user variables
;;   Use the user customization menu
;;     C-c u v
;;   to edit the user variables. (See the mode help from the edit buffer.)
;;   Each variable should be documented.
;;
;;   Ones of immediate importance:
;;     empire-attempt-highlighting
;;     empire-attempt-map-bars
;;     empire-highway-min-eff
;;     empire-interaction-verbosity
;;     empire-sector-civ-threshold
;;
;;5. Customize check and dump hooks.
;;   Use the user customization menu
;;     C-c u c
;;   and
;;     C-c u d
;;   to enable/disable hooks. At least look at these as they document alot of
;;   the tool's functionality.
;;
;;   If you save the world (\C-cs from the empire shell), all settings will be
;;   preserved into the future.
;;
;;  *** Subsequent emacs use on the same universe ***
;;  If this is a new emacs or you are swapping nations, restore the old data via
;;    M-x restore-empire (\C-cr)
;;  Now you need to bring emacs up to date on what may have changed. If not
;;  alot has changed and you are not concerned about levels and dists, use
;;    <tab> cen #
;;  to send a cen and have it scanned.
;;  If alot has changed, \C-xr (M-x refresh-empire) to update all things.
;;
;;  To get full analysis, there is \C-x\C-r (M-x refresh-adjust-empire) or
;;  \C-cx\C-e (M-x read-refresh-adjust-empire) to scan all things to the end
;;  of the buffer and then to do a refresh-adjust.
;;
;;  I generally refresh-adjust after each update and let the tool grow
;;  my country. I will help it out to force certain roads to get efficient as
;;  most roads let sectors from far away grow into a new sector. Without
;;  roads, you have a kind of sector to sector slow osmosys.
;;
;;		 *** How to Find Commands in the Tool ***
;; Almost all special commands are uncer \C-c. Try \C-c?? from all modes
;; and walk into whatever submenus you see.
;;
;; M-x describe-mode may also help.
;;
;; Ultimately, you can get documentation on all interactive empire
;; functions via
;;  M-x describe-empire-interactive-functions
;;  
;;			*** Analysis functions ***
;;  Certain functions offer suggestions of actions you could take. These will
;;  appear in different buffers depending upon the command.  Sugestions which
;;  are ready to execute empire commands will appear in the first column and
;;  may be executed by using \C-cx on that line. Other lines are things to
;;  consider or else things the tool is not smart enough to solve on its own.
;;
;;  Here is a summary of the buffers and the order they are most naturally
;;  scanned.
;;   *Flow* -- shows whole country flow broken down by dist centers.
;;   *Dump* -- shows  suggestions found during a dump scan. Level adjustments
;;             occur here.
;;   *Civ*  -- shows analysis of who can move out to populate new land
;;   *Food* -- shows suggestions to spread food over the roads
;;   *Mil*  -- shows suggestions to distribute mil uniformly accordign to
;;             sector type and nature or nearby threats.
;;   *Population* -- shows suggestions to keep population less than 900 in
;;             any sector so that pop growth does not stiffle.
;;   *Checks* -- various on the fly checks of status. Starvation warning and
;;             dist paths are done here.
;;
;;  If you tell the tool that you trust it, it will execute all suggestions
;;  as it makes them. (Remember that there is no warranty on the tool or the
;;  effects it may have on your country.)
;;
;;
;;			  *** Day to Day Play ***
;;At the start of a session, or at the end, I do a refresh-adjust-empire (I
;;trust the tool, mostly)
;;
;;Then I
;;Goto to *Flow* buffer and see who has flow problems (look for *), do a help
;;on empire-flow for format explinations.
;;
;;Goto *Dump* buffer for various adjustments
;;  if a line starts in col 0, it is a suggested command
;;  if you agree, type \C-cx to execute the command
;;  if you do not understand the command yet, you should probably agree.
;;
;;Goto *Civ* buffer 
;;  look at the proposed move commands. If you believe it, \C-cx
;;
;;Goto *Checks* buffer
;;  look at each proposed command, \C-cx most of them
;;  correct any country which is too hungry. If they have more than ~68
;;  bodies and are marked with a !, they will most likely starve if left
;;  uncorrected. 
;;
;;  Manually place in distribution paths where none was calculated.
;;
;;Goto *Food*, *population*, and *Mil* buffers
;;  do the commands (not as important)
;;
;;Maybe do another refresh-adjust-empire as the next dump pass sometimes
;;picks up new problems. The commands are written to make sure that you will
;;not have an immediate problem but earlier fixes are best.
;;
;;
;;For day to day operation
;;  Stay in the map most of the time with the empire shell in the other window
;;  use tab to start a command
;;   uygbnj or s to move in the map
;;   UYBNJU to move in the map AND in the empire shell
;;   @# to see mobility use
;;   DRCM... to run cen, res, move, dist, etc
;;
;;
;;Note:
;;  M-x empire-read-dump (\\[empire-read-dump]) reads ALOT and checks much
;;more. Consequently, it takes time. I typically do one only as part of a
;;refresh-empire or refresh-adjust-empire. It seems to take awhile, but the info
;;is generally useful and available faster than I would have found it on my
;;own. Read the *Dump* and *Checks* buffers to see what conclusions were made
;;from the dump. 
;;  M-x empire-quick-read-dump (\\[empire-quick-read-dump]) just reads the
;;  dump with no checks and is a faster way if all you want is the dist and
;;  level cutoff information updated.  The fastest update for most uses is
;;  to issue a census command from a tab command.
;;
;;  Now play empire while taking advantage of the map, census via click, path
;;  calculations, etc.
;;
;;  If things change, or new info is learned (such as by flights or
;;  explores), move to before the significant events and use one of the
;;  extraction commands (under C-c x) to get the new data. 
;;
;;  *** What the tool does for you while you are actively playing ***
;;  The biggest win is probably the maintenance of a world map. At 0 tech,
;;  I build fishing ships and sent them out. I look from each sector and on
;;  any land, I drop 1 mil and explore as soon as it gets mobility. The
;;  nav, look, and explore extraction commands make me a world map. (The
;;  nav extraction is real handy, it makes a no radar fishing boat just
;;  like a very slow patrol boat with no guns because it assumes that
;;  whenever nothing is known, there must have been sea all around the
;;  ship.)
;;  
;;  As a rule, I use a BUNCH of mines because my map will remember both where
;;  I drop them and where I find other people's mines. Others without this
;;  tool had better stay away from my waters.
;;
;;  Another win from the map is the calculation of movement paths, provided
;;  roads are available.
;;
;;  Using the gjyubn commands in the map will display cen data, dist node,
;;  and commodity level. You may use the map for route calcs (the mouse will
;;  help). 
;;
;;  The empire-checks cause me to never starve anybody (at least by accident)
;;  and let me know where to place my mil. They also let me know from where I
;;  can take civs to open up new land.
;;
;;
;;  *** What the tool does for you when you have strategy time ***
;;  The dump checks (length to run) are VERY handy as they suggest thresholds
;;  based upon sector type and detect when a sector holds goods it cannot use.
;;  They also detect mobility consticted sectors and attempt to fix these if
;;  possible by delivering excess to a nearby road.
;;
;;  The redistribution commands are handy because I can cause my entire
;;  roadway system to be maxed out with food and thus simultaniously feeding
;;  all warehouses. Local food shortages do not happen, and if they start to
;;  happen, I can generally get 5k food into any warehouse in an update just
;;  by using the tool to redistribute from roads with surpluses to 'hungry'
;;  roads which are typically distributing to the low on food warehouses.
;;
;;  The warehouse flow analysis is very good as it will let you know the net
;;  delta of each commodity in the next update and warns when there is less
;;  than a three day supply of any deplenishing commodity.
;;
;;  The redistribute population command makes sure that I can grow my
;;  population as fast as possibly by moving civs out of sectors nearly maxed
;;  out. This is great in new lands.
;;
;;  The redistribute civ command moves as many civs as will not starve into
;;  underpopulated sectors. I concentrate on road building in new lands and
;;  let this command move civs into the sectors near the roads.
;;
;;    Redistribute-population will move civs out of overfull sectors onto
;;    roads. Redistribute-civ will move civs into not yet full sectors from
;;    any overfull sector connected to them via high efficiency roads. Food
;;    content in the sectors is considered in the calculation of ideal
;;    population level.	 
;;    
;;    Using this, I expand into new territory by building the road first,
;;    taking and designating adjacient land, and letting the redistribute
;;    commands fill in these sectors.
;;    
;;    As distributed, the tool has a nice feedback cycle where the civs
;;    moved into a sector per unit of food is more than that supported by
;;    the suggested food level in the dist adjustment phase. Thus a cycle
;;    might go as follows:
;;       sector has designation, 1 civ, no food.
;;       redistribute-civ places ~ 60 civ there (depends upon version settings)
;;       dump scan suggests setting food level to ~ 20
;;       next redistribute-civ places more civs there
;;       .
;;       .
;;       .
;;       sector efficiency gets near 60%
;;       dump scan suggests level settings for iron, lcms, hcms, dust, etc
;;       .
;;       .
;;       .
;;       sector comes on line with lots of bodies and just the right amount of
;;	everything. 
;;
;;  *** What the tool could do for you if you invest the time ***
;;  MAKE YOUR OWN RULES! Or change the rules as the situation changes.
;;
;;  *** End of a session ***
;;  I generally take this as a time to have emacs crunch and do a full
;;  analysis including warehouse flows. The read-refresh-adjust-empire command
;;  will scan all things, ask all questions, do all analysys, and logout if
;;  asked.  I generally start this command from the top of the session,
;;  and walk away. (The command is of a 'fire and forget' nature.)
;;
;;		   *** Alternative Empire Strategies ***
;;This tool was based on a road center strategy and does not take into
;;account Scott Yelich's alternative scheme.  People using Scott's scheme can
;;still benefit from the level detectors and map support but automatic route
;;calculation will be useless. Redistribution commands (particularly
;;redistribute-civ) will work to spread out civs but will be limited to 1
;;sector range (sort of a slower osmosis).
;;
;;  *** Mouse ***
;;  If you have a sun mouse, you can select sectors, find out their cen data,
;;  dist center, and commodity level, and route to or from them by clicking
;;  on the map or on a sector reference in the shell. These are available to
;;  those without a mouse, but the keyindings are only so-so as I mostly use
;;  the mouse. \\[describe-mouse-bindings] will show the options in each buffer.
;;  YOU HAVE TO BE IN EMACSTOOL (not just emacs) to use the sun mouse.
;;
;;  If you have an X mouse, you can consider installing Darryl Okahata's
;;  x-misc.el (sent with the tool).
;;
;; If you DON'T WANT the mouse, then redefine the global use-mousep in
;; emp-db.el.  I don't like it because it screws up my normal mouse map.
;; You can move around the window with the mouse without any of this
;; defined anyway.
;;
;;------------------------------------------------------------------------
;;			  *** The Map Buffer ***
;;
;;The following commands are available in the map buffer:
;;
;;     C-cC-c
;;     TAB
;;	Execute an "extended" empire command.  See the section on
;;	"Extended Empire Commands", for details.
;;
;;     j u y g b n
;;	Move the cursor in the map buffer in the indicated direction.
;;
;;     J U Y G B N
;;	Move the cursor in the map buffer in the indicated direction,
;;	and insert the corresponding lowercase letter into the empire
;;	shell buffer.  This is useful when inserting long, hairy paths
;;	into the empire shell buffer.
;;
;;     H
;;	Insert an "h" into the empire shell buffer.
;;
;;     [Return]
;;	Execute the command in the empire shell buffer (acts just as if
;;	you pressed `[Return]' in the empire shell buffer).
;;
;;     i
;;	Insert the coordinates of the current map sector into the empire
;;	shell buffer.  A space is inserted before the coordinates if
;;	necessary.
;;
;;     C
;;	Perform a "census" on the current map sector, and read the
;;	census data.
;;
;;     D
;;	Do a "distribute" on the current map sector.  This command only
;;	inserts (and *executes*) the initial command:
;;
;;		distribute X,Y
;;
;;	where X,Y is the coordinate of the current map sector.	You must
;;	then use the uppercase direction keys (JUYGBN) to insert the
;;	distribution path into the empire shell buffer.  Press
;;	`[Return]' when the path is complete.
;;
;;     L
;;	Execute the "level" command on the current map sector.
;;
;;     P
;;	Execute the "path" command on the current map sector.
;;
;;     R
;;	Execute the "resource" command on the current map sector.
;;
;;     M
;;     E
;;     T
;;	Interactive "move", "explore", and "test" commands,
;;	respectively.  Each command will prompt for a commodity and an
;;	amount, and will insert (and *execute*) into the empire shell
;;	buffer a command of the form:
;;
;;		COM T X,Y A
;;
;;	where "COM" is the command; "T" is the commodity with which to
;;	explore, move, or test; "X,Y" is the coordinate of the current
;;	sector, and "A" is the amount.  At this point, you would use the
;;	uppercase direction keys (JUYGBN) to insert the path into the
;;	empire shell buffer, pressing `[Return]' as needed and at the
;;	end of the command (remember that simply pressing `[Return]'
;;	while empire is waiting for a direction letter is the same as
;;	pressing "h" followed by `[Return]').
;;
;;     Q
;;     #
;;     @
;;	Enter dynamic mobility mode (for details, see the section on
;;	"Dynamic Mobility Mode").  These commands are used to determine
;;	how much mobility will be used to move something, or to
;;	determine how much of a commodity can be moved.
;;
;;     p
;;	Insert into the empire shell buffer the path, to the current
;;	map sector, from the last sector referenced in the shell.
;;
;;     s
;;	Jump to a map sector.  You will be prompted for the X,Y
;;	coordinate of the new map sector.
;;
;;     c
;;	Switch to the empire shell buffer.
;;
;;     d
;;	Redesignate a map sector.  THIS ONLY AFFECTS THE MAP IN THE MAP
;;	BUFFER; it will not redesignate the sector in empire.  This
;;	command is intended to be used to designate shipping lanes "`"
;;	(when shipping lanes get implemented).	Note that you cannot
;;	designate a sector as "?", unless the sector type is not yet
;;	known or is a wilderness.  Also, do not designate a sector as
;;	"X" (you will not like what happens).
;;
;;     <
;;	Scroll the map buffer left half a window.
;;
;;     >
;;	Scroll the map buffer right half a window.
;;
;;------------------------------------------------------------------------
;;Extended Empire Commands:
;;
;;     The following commands can be executed by pressing TAB in any empire
;;buffer.  After pressing C-cC-c or TAB, you will be prompted for
;;one of the following commands; simply type enough of a command to make
;;it unambiguous and press [Return].  You will be prompted for any
;;information that the command requires (refer to the section on "Input
;;Conventions").
;;
;;     Check empire
;;	This command does the same thing as M-x check-empire.
;;
;;     Dump sectors quietly
;;	This command uses the "dump" command to dump sector data into a
;;	file, after which it is read and parsed.  Using this command has
;;	the advantage of not cluttering up the empire shell buffer with
;;	verbosely voluminous output.  Note that this command calls
;;	`empire-read-dump', which means that all dump hooks are called.
;;
;;     Map sectors
;;	This command acts like the "Dump sectors quietly" command,
;;	except that the "map" command is used.
;;
;;     cargo
;;     census
;;     coastwatch
;;     commodity
;;     deliver
;;     demobilize
;;     dump
;;     distribute
;;     enlist
;;     explore
;;     level
;;     move
;;     path
;;     production
;;     resource
;;     ship
;;     survey
;;     test
;;     threshold
;;	These commands act just like their empire counterparts, except
;;	that you will be prompted for any necessary information.  If a
;;	command requires a path, you will have to enter one using the
;;	uppercase direction keys (see above for information on uppercase
;;	direction keys).
;;
;;------------------------------------------------------------------------
;;Dynamic Mobility Mode
;;
;;
;;     **************************
;;     ***** IMPORTANT NOTE *****
;;     **************************
;;     As written, dynamic mobility mode uses the equations used by BSD
;;     Empire 1.1.  If you are using a different version of Empire, or if
;;     your version is using different equations to calculate mobility,
;;     etc., dynamic mobility mode will not work for you (it will give the
;;     wrong answers).  Beware!
;;
;;
;;     Dynamic mobility mode is entered by pressing "Q", "#", or "@" while
;;in the map buffer.  In this mode, you can display:
;;
;;* How much mobility is used when a given amount of a commodity is moved
;;  from the current map sector to another.
;;
;;* How much of a commodity can be moved from the current map sector to
;;  another, given a certain amount of mobility.
;;
;;Although you can display only one of the above at a time, you can easily
;;switch to displaying the other (by pressing the space bar).
;;
;;     If you press "#", you enter dynamic mobility mode, and the amount
;;that can be moved will be displayed.
;;
;;     If you press "@", you enter dynamic mobility mode, and the amount
;;of mobility used will be displayed.
;;
;;     If you press "Q", you enter dynamic mobility mode, and last display
;;mode will be used (initially, mobility used).
;;
;;     You will be prompted for the item to "move" from the current map
;;sector and the amount.	Note that, unless you press the "!" key (see
;;below), nothing is actually moved; you are only playing "what if" games.
;;
;;     Pressing the space bar toggles between the "mobility used" and the
;;"amount can move" displays.
;;
;;     At this point you can press the juygbnJUYGBN keys to move the map
;;cursor.  As the cursor is moved, the dynamic mobility display is updated
;;in the minibuffer status window.  If you make a mistake and move into
;;the wrong sector, you can press the DEL key to back up (the backspace
;;key will also work on some machines).  Please note that moves that
;;really "cancel out" (e.g, "b" followed by "u") do not cancel out as far
;;as dynamic mobility mode is concerned.	If you move into a sector that
;;you did not want to move into, use the DEL/backspace key to back up; do
;;not press the opposite direction key.
;;
;;     You can exit dynamic mobility mode in one of two ways:
;;
;;* You can press one of the "q", "x", or "h" keys.  This exits dynamic
;;  mobility mode, and moves the cursor back to the map sector that was
;;  current when dynamic mobility mode was entered.  Nothing is moved.
;;
;;* You can press the "!" key, in which case a:
;;
;;	mov C X,Y AMT PATH
;;
;;  command is inserted into the empire shell buffer.  Note that, unlike
;;  other commands, this command is not immediately executed -- you have
;;  to explicitly press `[Return]' to execute this command (this may
;;  change in the future).  "C" is the commodity being moved, "X,Y" is the
;;  coordinate of the starting sector (the map sector that was current
;;  when dynamic mobility mode was entered), and PATH is the path that was
;;  traversed to get to the current map sector.  AMT is the amount that is
;;  moved, and this depends on the display mode:
;;
;;     If the display is showing the mobility used, the amount that is
;;     inserted is the amount that you originally specified as moving.
;;
;;     If the display is showing the amount that can move, then that is
;;     the amount that is moved (the code should, however, check that
;;     this much exists and can be moved -- but it doesn't).
;;
;;     While dynamic mobility mode is active, you *CANNOT* issue normal
;;map buffer commands.  You must exit dynamic mobility mode before you can
;;execute a normal command.
;;
;;
;;------------------------------------------------------------------------
;;Input Conventions (& notes)
;;
;;
;;* Sector coordinates and sector ranges can be specified using the normal
;;  X,Y or Xmin:Xmax,Ymin:Ymax notations.  As a special case, "." (a
;;  single period without the quotes) means the coordinate of the current
;;  map sector.
;;
;;* When asked for a sector range, you cannot use the mouse to input a
;;  range.  This will hopefully be fixed in future versions.
;;
;;* Realms can be specified either as a single number (e.g., "5", "11",
;;  etc.), or a as the usual pound sign, "#", followed by a number (e.g.,
;;  "#5", "#11", etc.).  Specifying the pound sign is optional.
;;
;;* When asked for a commodity or people (civ, mil) type, you only have to
;;  type enough of the name to make it unambiguous.
;;
;;* When asked for a condition (e.g., "?civ>100"), you do not have to
;;  enter one.  If you do enter one, you do not have to type a leading "?"
;;  (one is added if necessary), and you can use spaces (they are removed
;;  before the command is sent to empire).
;;
;;			*** Lisp Customization ***
;;  This section starts to talk of how to change the lisp itself.
;;  
;;  > Also, are you familiar with any feature to locate a functions file
;;  > location (IE which *.el file).
;;  
;;  Use the tags distributed with emacs. 
;;    etags  -e "emp-db.el" "emp-option.el" "emp-help.el" "emp-anal.el" "emp-shell.el" "emp-float.el" "emp-sector.el" "emp-auto.el" "emp-modes.el"
;;    M-x visit-tags-table <cr>
;;    Esc . will now find almost anything.
;;
;;  M-x grep is also good. Follow up with Esc-`


;; > (I have a question, how can I get my very large country, full of
;; > undeveloped and distant highways, set up with distribution routes?)
;; Make sure that 'check-and-fix-dist is a enabled check hook (via \C-cuc).
;; This will extend dist paths, but some paths need to be "seeded" first.
;; (Tool suggested dist path growth is like crystal formation). The tool will
;; dist ONLY to existing dist points as determined by scanning dump command
;; outut and doing empire-flows. Thus in each new area, do a few distributions
;; by hand (possibly via D on the map), dump the sectors, scan them, do an
;; empire-flows and then an empire-check. 
;; 
;; The tool does NOT automatically update its database with the suggested
;; distributions as it does not know if you really chose to use them. Thus,
;; sometimes cycles of dump, scan, flow, and check are needed. This cyclic
;; behavior is actually in many cases desirable because it causes a steady
;; growth rate while limiting exponential growth performance problems.

;; Help on keys and commands
;; USE \C-c? FROM THERE MAP, EMPIRE, AND DATA BUFFERS. Also use M-x
;; describe-mode.  All things should be be described in one or another of
;; these screens. 

;;Subject: Beginner empire
;;
;;Much of empire is economic, not military. People forget this and allow
;;themselves to fall into a trap that leads to poor military and then massive
;;losses. If you can run a balanced country and grow fast, you will generally
;;win even if you spend your mil $ somewhat poorly.  Case in point
;;demonstrating economic warfare: I attacked only parks (which were on the
;;outskirts of his islands because he thought they were of low mil value)
;;until he had so much internal rebellion that he was a pushover.
;;
;;My gnu emacs empire tool has lots of rules that help you manage a country.
;;Level settings are suggested, routes are calculated, constipation of
;;production is detected, etc.  There are also commands to move folks from
;;full population sectors into non-full sectors and to achieve an ideal mil
;;balance in each sector according to its designation.
;;
;;Rules of thumb: 
;;
;;  Explore and get the outline of your land mass before doing much
;;  designation -- you will grow smarter that way. Good tools will map your
;;  world based upon a series of explores; even a 2k continent can be
;;  outlined in 3 or 4 updates.  Remember and summarize all resources you
;;  find so that you know where to grow when; a good tool will do this
;;  for you.
;;
;;  Remember: people are $ and so are uw -- have as much as possible of both. 
;;            Mil is anti $
;;
;;  Watch the mountains. If I explore and find you, I will often move  a
;;  couple of civs into mountains in your growth path. Much later, I will
;;  enlist them and attack you in the heart of your country. For example,
;;  somebody had an airport of about 50 planes and 1 mil next to a mountain
;;  where I had 40 mil; good thing he was an ally or else it would have been
;;  bye-bye planes. Next time it might be a capitol, bank, or warehouse.
;;
;;  Place forts on water edges until planes overpower ships (about the time
;;  of jet lt bombers).
;;
;;  Keep airports, warehouses, etc away from water edges -- they are just too
;;  attractive to passing battleships.
;;
;;  If there is no convient sector for a warehouse, use a road; it is almost
;;  as good.
;;
;;  Escort 2's are good even after jet fighters because of their very long
;;  intercept range. High tech escort 2's will intercept 15 or more sectors
;;  away. 
;;
;;  Use fighter 1's eveywhere you might use a sam. They are just as effective
;;  and are reuseable. High tech fighter 1's are just good as an equivilent
;;  tech sam.
;;
;;  If some forts are really p*ssing you off, ssm's can take them out but at
;;  a high cost.
;;
;;  In most worlds, the following are good sector des rules
;;    forget about uran, by the time you can use it, it is easily extracted.
;;    85%mineral or more for a mine. In some worlds, 95% or more.
;;    30%oil or more for an oil platform.
;;    Initially 60 and later 30% or more for gold.
;;    95% or more fert for ag centers.
;;
;;Tricks:
;;  use mine fields -- alot of them -- to keep ships away and to make private
;;  lakes. Of course, it helps if your tool remembers where you layed the
;;  mines. In particular, I mine the edge of my major lands to make spying
;;  from ships (and assaults) hard to sustain. Case in point: I left for a
;;  week and my opponents all knew I was leaving for two weeks in advance. My
;;  outer minefields kept them away until I got back and blew away the crippled
;;  remaints of their invasion fleets; they should have had LOTS of minesweeps.
;;
;;  When mining, mine some sectors very heavily (10+) and some very lightly
;;  (1 or 2). The heavily mined sectors tend to blow up minesweeps (which
;;  only pick up 5), and the lightly sectors may go unnoticed by "test"
;;  vessals such as fishing or patrol boats and get something nicer such as a
;;  carrier. 
;;
;;
;;Nasty trick:
;;  Take an oponent's sector, set the thresholds way up, set delevery
;;  levels lower than the threshold, and deliver to oponent terretory
;;  (preferably a road). Then bug out being sure to leave so few mil that the
;;  sector is sure to revolt.  When it does, it will endless draw from its
;;  dist point and del to the road. If you get lucky, you will empty the
;;  warehouse of food, lcm, hcm, oil, etc. If you get real lucky, the oponent
;;  will not notice because he got the sector back and you have him
;;  preoccupied elsewhere.
;;
;;  Varient: If the sector taken is a road and you know a low cost route to a
;;  bank, redo the dist to take bars from the bank. Take the sector back the
;;  next turn and get all the bars!   
;;
;;  This trick is so nasty that it should be outlawed; maybe a change that
;;  you need mil control to change dest and levels. Maybe a change so that
;;  dest and levels change only after you own the sector for so man updates.
;;
;;  Protection: A good tool (such as gnu emacs empire) will detect when this
;;  has been done to you and will suggest restorations to the dist and del
;;  thresholds. Of course, you have to log in before the next update.
;;
;;Future:
;;  Watch Dr. Strangelove and think of what would happen if you define a
;;  command to login, grep news for nuke strikes, and auto launched a
;;  retaliation. A better form of this may be a standard feature in the next
;;  gnu empire tool.
;;  
;;Batch Play
;;  Read empire-batch to see what you can do in batch mode. This mode is
;;  now sufficienty robust that I use it to refresh and adjust my countries
;;  (all 7 of them) after each update and I just login to see what's
;;  happening and to adjust and grow.
;;
;;  I generally enable auto-fire and when challanged run it several times
;;  an hour. In one instance, a tech 40 country kept a tech 300 away for
;;  months using this and the tool's natural ability to repair a damaged
;;  country. Bombing is not as useful when civilians rush from the far
;;  courners of the country to repair the damage.

;; Particularly interesting questions and their replies
;; > The tool has done all the civ moving, etc ...
;; >   The tool would move civs out and start developing sectors, but it
;; > did not seem to be moving food out for these people to eat!
;; The tool only moves the number of civs that can be fead. You can tell that
;; the sector is food limited because the *civ* buffer will show it as having
;; "10F" rather than "10f" (the "F" is capatilized on food limited sectors).
;; Conversely, it will move civs out of sectors whose food is insfficient but
;; does not typically do so fast enough.
;; 
;; The trick is that the next dump scan will bump the food threshold to
;; support the current number of bodies PLUS A GROWTH FACTOR -- the growth
;; factor will cause move civs to be allowed next time.
;; 
;; All this fails if the place to which the sector dists is unable to keep the
;; sector fead; in this case the new sector and the dist pt will eventually
;; both starve.
;; 
;; Newer releases (2.b) bump the threshold when they move the civs so as to
;; not be so dependent on when the next dump is scanned.
;; 
;; > The tool has done all the civ moving, etc; but seems to like to move a
;; > bunch of civs into a sector
;; Use \C-cuv (empire/ customization/user vars) to edit the
;; empire-sector-civ-threshold to be around 150 -- this is much better for
;; initial growth but will not max out mature countries. When you see much
;; more than 55 civs on roads for any length of time, bump the threshold up in
;; incriments of about 150 until it reaches about 800. Setting it higher than
;; that is pointless as pop growth will fill the sector out very quickly from
;; that point and the sector is best used as a civ source rather than a sink.
;;
;; 

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Release Notes -- these are extracted and used to compose mail
;; rnotes->This is GEET (Gnu Emacs Empire Tool) release 2d.
;; rnotes->This is ageneral release and should have no major problems.
;; rnotes->
;; rnotes->Things about this release:
;; rnotes->  Resource information is kept for the sectors. Old worlds will
;; rnotes->    have a 1 time conversion performed.
;; rnotes->  Ships are parsed much better and ther is a sail mode,
;; rnotes->    but you have to use lisp expressions to run it.
;; rnotes->  Ships will have auto food transfer so a fishing boat can
;; rnotes->    keep a fleet happy.
;; rnotes->  Planes are handled much better and auto bomb and drop are
;; rnotes->    enabled
;; rnotes->  Maps are drawn better.
;; rnotes->  Sectors can display in any number of different formats.
;; rnotes->  There is a survey mode.
;; rnotes->  There are alternative civ and mil distribution schemes.
;; rnotes->  The code is split up much more logically.
;; rnotes->				    -*-

;; rnotes->The file emp-install.el describes mailing lists. Write
;; rnotes->to be put on the list to get fixes or enhancements. Please use
;; rnotes->these lists and not the net so as to not bother non tool users
;; rnotes->(just take over all their land instead).
;; rnotes->


;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Below is a standard "copyleft". It lets you do pretty much what you want
;; except to sell this for profit without giving away the source at no cost.
;; In general, if you make no $, do not worry about it. Sorry about the
;; hassle, but people are so sensitive about empire tools that I want to
;; make sure this stays free.

;;			COPYING POLICIES
;;
;;  1. You may copy and distribute verbatim copies of this source code
;;as you receive it, in any medium, provided that you conspicuously and
;;appropriately publish on each copy a valid copyright notice "Copyright
;;(C) 1990 Lynn Randolph Slater, Jr." (or with whatever year is
;;appropriate); keep intact the notices on all files that refer to this
;;License Agreement and to the absence of any warranty; and give any
;;other recipients of this source a copy of this License
;;Agreement along with the program.  You may charge a distribution fee
;;for the physical act of transferring a copy.
;;
;;  2. You may modify your copy or copies of this source code or
;;any portion of it, and copy and distribute such modifications under
;;the terms of Paragraph 1 above, provided that you also do the following:
;;
;;    a) cause the modified files to carry prominent notices stating
;;    that you changed the files and the date of any change; and
;;
;;    b) cause the whole of any work that you distribute or publish,
;;    that in whole or in part contains or is a derivative of this source
;;    or any part thereof, to be licensed at no charge to all third
;;    parties on terms identical to those contained
;;    in this License Agreement.
;;
;;  3. You may copy and distribute this program (or a portion or derivative 
;;of it, under Paragraph 2) in object code or executable form under the terms of
;;Paragraphs 1 and 2 above provided that you also do one of the following:
;;
;;    a) accompany it with the complete corresponding machine-readable
;;    source code, which must be distributed under the terms of
;;    Paragraphs 1 and 2 above; or,
;;
;;    b) accompany it with a written offer, valid for at least three
;;    years, to give any third party free (except for a nominal
;;    shipping charge) a complete machine-readable copy of the
;;    corresponding source code, to be distributed under the terms of
;;    Paragraphs 1 and 2 above; or,
;;
;;    c) accompany it with the information you received as to where the
;;    corresponding source code may be obtained.  (This alternative is
;;    allowed only for noncommercial distribution and only if you
;;    received the program in object code or executable form alone.)
;;
;;  4. You may not copy, sublicense, distribute or transfer this code
;;except as expressly provided under this License Agreement.  Any attempt
;;otherwise to copy, sublicense, distribute or transfer this code is void and
;;your rights to use this code under this License agreement shall be
;;automatically terminated.  However, parties who have received computer
;;software programs from you with this License Agreement will not have
;;their licenses terminated so long as such parties remain in full compliance.
;;
;; 5. I realize that "copylefts" are not universally loved. If you wish to
;; distribute this more freely (such as with BSD empire), contact me and I
;; will probably send you a copy with restrictions compatable to whatever
;; you already use. 
;;
;;			   NO WARRANTY
;;
;;  BECAUSE THIS CODE IS LICENSED FREE OF CHARGE, I PROVIDE ABSOLUTELY
;;NO WARRANTY, TO THE EXTENT PERMITTED BY APPLICABLE STATE LAW.	 EXCEPT
;;WHEN OTHERWISE STATED IN WRITING, LYNN RANDOLPH SLATER, JR, AND/OR OTHER
;;PARTIES PROVIDE THIS CODE  "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
;;EXPRESSED OR IMPLIED, INCLUDING, 
;;BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
;;FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY
;;AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THIS CODE
;;PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
;;SERVICING, REPAIR OR CORRECTION.
;;
;; IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL LYNN RANDOLPH SLATER, JR
;;AND/OR ANY OTHER PARTY WHO MAY
;;MODIFY AND REDISTRIBUTE THIS CODE AS PERMITTED ABOVE, BE LIABLE TO YOU
;;FOR DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER
;;SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
;;INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA
;;BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A
;;FAILURE OF THE PROGRAM TO OPERATE WITH PROGRAMS NOT DISTRIBUTED BY
;;FREE SOFTWARE FOUNDATION, INC.) THE PROGRAM, EVEN IF YOU HAVE BEEN
;;ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR FOR ANY CLAIM BY ANY
;;OTHER PARTY.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; DISCLAIMER
;;     I mail this from my employeers machines, but they otherwise have
;;     nothing to do with this program. I am 
;;	 Lynn Slater -- lrs@indetech.com or {sun, ames, pacbell}!indetech!lrs
;;	 42075 Lawrence Place, Fremont Ca 94538
;;	 Office (415) 438-2048; Home (415) 793-1864; Fax (415) 438-2034

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The next sections reflect things to do or bugs
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; New sector data storage technique
;;   Each sector data has (x y des own) in first 4 elements
;;   5th element is (cons <empire-pos> vector) where <empire-pos> is an
;;   alist of (symbol . offset) and the vector holds the values
;;   corresponding to each symbol at the respective offset.
;;
;;   The advantage of this theme is that sectors can have different data
;;   stores; potentially a unique one for each sector. In practice, a
;;   unique empire-pos for each sector would take too much memory and what
;;   would be done would be to establish an empire-pos array for the
;;   following:
;;     sectors with cen/prod/res/dump data
;;     sectorx with only explore data
;;     sectors with spy/look data
;;     sectors with only designations known
;;
;;   The code that first did a record-des would pass the empire-pos array.
;;   recall would have to return nil for any value not in the empire-pos of
;;   that sector.
;;
;;   The complication of the scheme is that the vector types have to be
;;   upgraded and rarely downgraded. For example, a spy should replace a
;;   des only vector with a spy vector but should not replace a cen vector
;;   (which might exist if you owned that sector once).	 When changing
;;   vector types, all data from the old vector should be transferred into
;;   corresponding positions (if any) the new vector.
;;   
;;   The other complication is to make mapsects and empire-row-ranges work
;;   only on the cen/dump sectors so that the tool does not take forever
;;   checking sectors for which nothing is known.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; In the variant of shell mode for running empire,
;;   add process filters to detect and display on the map
;;	 mines as they happen
;;	 move, nav, explore as it happens
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Better analysis
;; Better total flow usage
;;   i.e. have user set desired edu/happy levels, acceptable plague level,
;;     and desired tech growth rate.
;;   Calc, set levels, and move resources so that those levels are acheived
;;     taking into account factors such as max tech growth rate and
;;     tech/research drain.
;; Detect flow through a highway
;;   Find all that uses this highway -- good if you want to redesignate the highway
;; Detect routes through non highways when highway only routes are available
;; Summarize national commodities (maybe only those in warehouses)
;;   calc # days of tech growth/max tech level at current consumption rates
;;   calc # days of research at current consumption
;;   calc likely dust surplus that can be made into bars without halting
;;     tech or research production in the future.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Better redistribution
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Also "shipping lanes" -- sort of a highway at sea
;;   with related path finding commands
;;   (You could then make a shipping lane, mine all around it, and let
;;   emacs dodge the mines.)
;; Navagation by desired destination
;;   emacs calcs a optimal path
;;     low cost
;;     not mined
;;     not near hostile countries or more powerful hostile ships
;; Split navigation
;;     if ship runs out of mobility before getting there, have emacs store
;;     the destination and path and reissue the nav later.
;; Auto hunting
;;     a nav mode where you move, sonar, and move on if no sub spotted.
;; Enemy waters navigation
;;     have minesweeps preceed fleet, halt if mines detected until
;;	 confidant they are cleared.
;;     have destroyers follow minesweeps looking for subs
;;     send patrol boats out as scouts
;; Auto info:
;;     have patrol boats operate loops in remote waters.
;;     Maybe have fishing boat near to feed patrol boats from time to time
;;     Have patrol boats explore unknown waters
;;     Have fishing trawler follow a set of other country ships
;;	 just as russians follow US ships.
;;	 Maybe they will not attack it if you are not at war.
;;	 If they do attack it, prepare for war.
;; Auto oil exploration
;;     Have oil derricks nav if not in productive sector
;;     store sea sector oil resources for efficiency
;;     explore near land first
;;     explore near oil sectors first
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Make map use point and mark more consistently
;;   point is where you are
;;   mark is destination
;;   exchange point and mark very handy
;; shipping lanes and lane path calcs
;; ship lane path calc MUST take shortest path
;; nav/view/look cycle using general direction.
;; general set anything from the map, + forget it all
;; impliment mapsects-until
;; impliment two stage move: calc movement capacity of a road net
;; \C-x s, r, w, f to apply to empire world in empire shell mode.
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; tool should play while awaiting shell
;; shell should display as it goes
;; exp via explode out would be nice (i.e. expand from a sector until no mob)
;; explore mode where map commands move guy and it goes to shell would be nice
;; chained route calcs -- remember where last clicked
;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; need repeat command
;; auto extract upon doing cen
;; auto map when des change
;; auto explore extract
;; bounds change changes current buffer
;;  explores redes beyound map end

;; ttd 
;;   new country commands  - i.e.
;;     second day nova
;;     get 1 mine, 1 ag, 1 w, 1 j, 1 e, 1 l
;;   read-string-default tab inserts default string into buffer
;;   set bounds by mouse set bounds to last bounds?
;;   new short rd calc
;;     later use lowest cost path calc

;;   need better behavior after quit
;;     use comint input filters

;; Bugs
;;* The reading of exploration data dies if the data being read is outside
;;  of the empire map buffer boundaries (something like `forward-char'
;;  hits end of buffer, or somesuch).
;;
;;> A new command, M-x empire-break-new-world, renamed my country, set up the
;;> DB, and acquired and designated the following 95 sectors. The con side is
;;> that is used up all mobility (in some cases, it will use all the btu's).
;;> 
;;> Is this a handy command or is it advocating a bad strategy of grabbing
;;> before you can use it. How grabby is grabby enough? Maybe there should be a
;;> preferred grab depth. (I am looking into grabbing rings at a given depth.)
;;
;;     Whether this is good or bad depends on the game.  In some games,
;;you need to grab land quickly.  In others, you don't.
;;
;;     You will want to place a user-definable limit on how many sectors
;;you grab.  If you grab too many, you won't have enough civilians to
;;increase sector efficiency fast enough (you'll have too many civilians
;;scattered all over the place).  You'll probably want to make the "grab
;;limit" depend on your total population.  At first, you'll want to limit
;;the number of exploring civilians, as these civilians would be better
;;off making babies than exploring.  However, you'll reach a point where
;;you'll be able to afford to have a couple hundred civilians exploring
;;and taking new sectors.
;;
;;     Another nice function to have would be something like
;;`empire-deep-space-explore', where one civ or mil would just run around
;;the edge of the continent/island (or search for the edge), exploring the
;;shape of the land mass.

;; split out the "f needs" into a seperate dump hook
;;   split out food thr setting to seperate hook?
;;   split out redesignation?
;; make proposed levels be for full up operation of all sector types?
;; make ideal-civ, ideal-mil, and ideal-food be user named fcns
;; try oscalating redistribute-civ to pump civs out better
;; make empire.el

;; ttd
;;From: DavE Nye <evil@BBN.COM>
;;
;;Work needs to be done on 'empire-break-new-world' and 'nova' and 
;;'supernova'.  These need to be made alot faster.  I'm being
;;beaten by dudes with cut and paste and faster typists.. :)
;;
;;Couple of suggestions:
;;
;;1. streamline the sequece of commads needed when you run a 'empire-break
;;   -new-world'.  Ie. remover the 'sat * >' commands that are never there
;;   in a NEW world.  These comands take time.  Time to issue the commands,
;;   Time to wait for them to return, Time to scan the nothing...etc..
;;
;;2. Make the nova and supernovas not have to do a map EVERY time they take
;;   a sector.  When it has a map, scan it and issue rapid fire explore
;;   commands to grab all the sectors that are '-'.  Then when all the
;;   sectors in the present map are gone, do another small map and repeat.
;;   
;;> 3. Another time saver would be not to do a census of the ROOT sector 
;;>    every time you complete an explore.  Save this info in a varaible
;;   somewhere and calculate the reductions in the mob and civs as
;;   you run the explores.  Why wait for the response from the server.
;;   Do it local!!  NET LAG is a killer..it is bad to compound the
;;   lag by issuing multiple server based commands that you could
;;   do locally faster.
;;
;;> 4. When break-new-world trys to set up a coutry by designating sectors
;;>    it issues a command like... 'des * ?min>70&mob=0 m'.  Playing 
;;>    BlitZ games I've had a problem that an update occurs and all of a sudden
;;>    I have a hundred sectors with mob and this command does nothing.  How about
;;>    we issue a command like... 'des * ?min>70&des=+ m'?
;;
;;:)
;;
;;From: thoth@manatee.cis.ufl.edu
;;  Perhaps we should consider creating a separate
;;module called emp-regexp that contains the all the
;;regexps that could reasonably be subject to change
;;(maybe even the ones subject to unreasonable change).
;;
;;From: darryl and troth
;;troth: Date: Fri, 11 Jan 91 13:18:05 EST
;;> darrylo says
;;>
;;>     Here is my idea for a redistribute-pop alternative:
;;>...group "road" sectors into "regions"...
;;>     It would also be nice to have a single `redistribute-everything'
;;>function.
;;
;;  This is what Matt Dillon's manage does (after I fixed
;;the code).  It seems to function rather well and I often
;;use it when I can't get GEET to do the right thing.
;;
;;  It chops the world into segments that are road
;;connected and figures out what is surplus and what is
;;not and then emits the commands to move stuff
;;everywhere.  You don't need warehouses if you use manage.
;;
;;From: lrs
;;  test survey, poll users, see which one to use
;;      hang survey commands
;;>  test invisible map stuff, mail it back out
;;  move regexpressions out, use smarter constructors such as the one
;;    used in planes
;;  find-dist-path to not go exponential on all +
;;  use emp-dev on new world
;;  terretories
;;  redistribute-civ and mil to change their push/pull orientation
;;  make real the mapsects road walkers
;;  document tuning to run large GEET
;;  make empire adjust hook edit mode
;;  trace geet mem usage, document how to trace in the field
;;  make road walkers not recurse -- less garbage generation
;;  make use of road regions?
;;    Darryl says:      The basic improvement is to scan the sector database
;;                      once or twice, and group "road" sectors into
;;		      "regions", where a region is a list of ...
;;  vector rearrangement on change im emp-pos
;;
;;  I promised on import-to-sector
;;  ship sail order editor
;;  sail ship/fleet seperation
;;  faster nova, do not des as often
;;  explore the new ideal-civ-forsman stuff. go until no civ, parse for no
;;     mob, cen and map first
;;  auto-des to ask for min mob limit
;;  emp-constant.el file needed. Might even have regexps
;;  mail treatus on how to place helper fcns w/o update blow away
;;  highway network mobility scavanger
;;  blitz support
;;  redesignator/next designation
;;  publish large country tuning
;;  take ships away after a coastwatch
;;  reinstall emp-des-in-map
;;  make adjust mode register commands
;;  make easy sail nav command
;;  keep enemy ship pos, including previous known positions
;;  ships seen by close radar nor replaced by sea seen by far radar
;;  auto retake of lost land
;;  auto rollover of enemy land
;;  auto sat grid calc
;;  ship load of guns, food, mil, civ when in harbor
;;  nav with l,r,s, built in and min mob to preserve
;;  find plane/airport that can get toa certain sector
;;  launch command
;;  take island by air command
;;  reinstall "empire-des-in-empire-map" in the map
;;  have mil reserve target and dem excess from e
;;  enl when work drops,
;;  bit array (work drop, plague, constipated, unrest)
;;  detect r/t production halt, move around
;;  get sail to work
;;  get thr p/l and detect against
;;  get lost check again working
;;  get route parse on command line to find last sector referenced
;;  aslt highlight letter, generage highlite-sector fcn
;;
;;>   being able to tell GEET "I want this to be an 'x'; please designate
;;>  it as such after you've moved your first load of people in" could be
;;
;;
;;Robert:
;;  adjust happyness/education to given level
;;  note when there is not pruduction surplus for new growth  
;;
;;Darryl:
;;  compile time option on macro .vs. non-macro recall
;;
;;(get randy's comments from archive)
;;
;;empire break new world bug
;;case fold search issues
;;
;;coding users guide:
;;  headers
;;  always indent
;;  single blank lines
;;  box comments
;;  comments in the fcn, not before
;;  no space before doc string
;;
;;store resource info (troth)
;;what does randy want stored?
;;
;;look, sonar to record ship data
;;nav prompts into db
;;sats to not record ? over -
;;
;;test survey
;;import to sector
;;bank endless flow
;;
;;fix empire-prompt-read-ship
;;merge map-insert-location and empire-insert-map-sector
;;merve move-to-XY-in-empire-map and  move-to-in-empire-map
;;reduce-production and take-out into a map
;;file manip map
;;actions on prompt, but not yet a return to be considered
;;can empire-toggle-dev-sector-display and that display-sect call
;;
;;paradrop needs to use closest planes and to calc amount in sector before
;;  trying drop
;;  Also needs to use planes with max mobility from those avail
;;demobilize to do only enlistment centers?
;;plane checks do not go to stdout in batch mode
