#ifndef lint
static char *RCSid = "$Header: fileinit.c,v 1.3 89/09/26 20:01:22 mr-frog Exp $";
#endif /* not lint */

/*
 * fileinit.c
 *
 * Stuff that ef_init uses to initialize the
 * ca pointers and the pre/post i/o calls.
 * Only used by the client.
 *
 */

#include <fcntl.h>
#include "misc.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

extern	struct castr sect_ca[];
extern	struct castr news_ca[];
extern	struct castr loan_ca[];
extern	struct castr ship_ca[];
extern	struct castr plane_ca[];
extern	struct castr treaty_ca[];
extern	struct castr nuke_ca[];
extern	struct castr trade_ca[];

extern	int sct_postread(), sct_prewrite();
extern	int shp_postread(), shp_prewrite();
extern	int lnd_postread(), lnd_prewrite();
extern	int pln_postread(), pln_prewrite();
extern	int nuk_postread(), nuk_prewrite();

struct fileinit fileinit[EF_MAX] = {
	sct_postread,	sct_prewrite,	sect_ca,
	0,		0,		news_ca,
	0,		0,		loan_ca,
	shp_postread,	shp_prewrite,	ship_ca,
	pln_postread,	pln_prewrite,	plane_ca,
	0,		0,		treaty_ca,
	nuk_postread,	nuk_prewrite,	nuke_ca,
	0,		0,		trade_ca,
	0,		0,		0, /* power */
	0,		0,		0, /* nation */
	lnd_postread,   lnd_prewrite,   land_ca,
};

ef_init()
{
	int	i;
	struct	empfile *ef;
	struct	fileinit *fi;

	ef = empfile;
	fi = fileinit;
	for (i=0; i<EF_MAX; i++, ef++, fi++) {
		ef->postread = fi->postread;
		ef->prewrite = fi->prewrite;
		ef->cadef = fi->cadef;
	}
}
