#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/wing.c,v 1.4 89/06/08 20:08:28 griffith Exp $";
#endif /* not lint */

/*
 * wing.c
 *
 * add planes to wing
 *
 * from flee.c (from PSL Empire, 1985) 1989
 */

#include <ctype.h>
#include "misc.h"
#include "player.h"
#include "var.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

wing()
{

	struct plnstr plane;
	register int count;
	s_char	*cp;
	s_char	c;
	struct	nstr_item nstr;
	s_char	buf[1024];

	if (!(cp = getstarg(player->argp[1], "wing? ", buf)))
		return RET_SYN;
	c = *cp;
	if (!isalpha(c) && c != '~') {
		pr("Specify wing, (1 alpha char or '~')\n");
		return RET_SYN;
	}
	if (c == '~')
		c = ' ';
	if (!snxtitem(&nstr, EF_PLANE, player->argp[2]))
		return RET_SYN;
	for (count = 0; nxtitem(&nstr, (s_char *)&plane); count++) {
		if (plane.pln_own != player->cnum) {
			count--;
			continue;
		}
		plane.pln_wing = c;
		putplane(nstr.cur, &plane);
	}
	pr("%d plane%s added to wing `%c'\n", count, splur(count), c);
	return RET_OK;
}
