/* 
 * force.c
 *
 * Force an update
 * 
 * Dave Pare, 1994
 */

#include <sys/types.h>
#include "misc.h"
#include "player.h"
#include "lwp.h"

int
force()
{
	extern	struct lwpSem *update_sem;
	extern	int update_pending;
	int	seconds;
	time_t	now;

	if (update_pending) {
		pr("Update is pending\n");
		return RET_FAIL;
	}
	if (updates_disabled()) {
		pr("Updates are disabled\n");
		return RET_FAIL;
	}
	seconds = onearg(player->argp[1], "Time until update [in seconds]? ");
	if (seconds < 0)
		return RET_FAIL;
	if (seconds) {
		time(&now);
		pr("Waiting %d seconds...\n", seconds);
		lwpSleepUntil(now + seconds);
	}
	pr("Scheduling update now\n");
	lwpSignal(update_sem);
	return RET_OK;
}
