/*
 * nsc.h
 *
 * defines for empire conditionals.
 *
 * rewritten by Dave Pare, 1989
 * $Revision: 1.7 $ $Date: 89/09/17 14:56:01 $
 */

#define NS_LSIZE	128
#define NS_NCOND	16

struct	nscstr	{
	long	fld1;			/* first commodity or number */
	long	fld2;			/* second commodity or number */
	int	oper;			/* required relationship operator */
};

struct nstr_sect {
	coord	x, y;			/* current x-y */
	coord	dx, dy;			/* accumlated x,y travel */
	int	id;			/* return value of sctoff */
	int	type;			/* type of query */
	int	curdist;		/* dist query: current range */
	struct	range range;		/* area of coverage */
	int	dist;			/* dist query: range */
	coord	cx, cy;			/* dist query: center x-y */
	int	(*read)();		/* read function */
	int	ncond;			/* # of selection conditions */
	struct	nscstr cond[NS_NCOND];	/* selection conditions */
};

struct nstr_item {
	int	cur;			/* current item */
	int	sel;			/* selection type */
	int	type;			/* item type being selected */
	int	curdist;		/* if NS_DIST, current item's dist */
	struct	range range;		/* NS_AREA/NS_DIST: range selector */
	int	dist;			/* NS_DIST: distance selector */
	coord	cx, cy;			/* NS_DIST: center x-y, NS_XY: xy */
	int	group;			/* NS_GROUP: fleet/wing match */
	int	size;			/* NS_LIST: size of list */
	int	index;			/* NS_LIST: index */
	int	list[NS_LSIZE]; 	/* NS_LIST: item list */
	int	(*read)();		/* read function */
	int	flags;			/* EFF_ flags */
	int	ncond;			/* # of selection conditions */
	struct	nscstr cond[NS_NCOND];	/* selection conditions */
};

#define NS_UNDEF	0
#define NS_LIST		1
#define NS_DIST		2
#define NS_AREA		3
#define NS_ALL		4
#define NS_XY		5
#define NS_GROUP	6

/*
 * looks something like this:
 * T: type of pointer.
 * C: catagory of value.
 * V: value.
 *
 * xxxx xxxx xxxx xxxx
 *    T TTCC VVVV VVVV
 */

/*
 * catagories
 */
#define NSC_VAL		(0)	/* normal number */
#define	NSC_VAR		(1<<16)	/* is a vtype */
#define	NSC_OFF		(2<<16)	/* is a sect/ship offset */
#define NSC_UNIT	(3<<16)	/* unit present flag */
#define	NSC_CMASK	(3<<16)

/*
 * how to interpret "offset" fields
 */
#define NSC_CHAR	(1<<18)	/* pointer to s_char */
#define NSC_UCHAR	(2<<18)	/* pointer to uchar */
#define NSC_SHORT	(3<<18)	/* pointer to short */
#define	NSC_LONG	(4<<18)	/* pointer to long */
#define NSC_TMASK	(7<<18)

#define NSC_COORD	NSC_SHORT	/* change if coord typedef changes */
#define NSC_NATID	NSC_UCHAR	/* change if natid typedef changes */

#define NSC_MASK	(0xffff0000)

struct	castr	{
	long	ca_code;	/* encoded form */
	s_char	*ca_name;	/* name used for matches */
};

/* variables using the above */

extern  struct castr sect_ca[];
extern  struct castr var_ca[];
extern  struct castr ship_ca[];
extern  struct castr plane_ca[];
extern  struct castr land_ca[];
extern  struct castr ca[];

extern	s_char *nstr_comp();
