#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/ship.c,v 1.11 89/05/10 02:54:09 muir Exp $";
#endif

/*
 * ship.c
 *
 * do "production" for ships -- make more efficient,
 * charge for military, etc.
 *
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "ship.h"
#include "var.h"
#include "news.h"
#include "file.h"
#include "product.h"

int
prod_ship(etus)
	int	etus;
{
	register struct shpstr *sp;
	int	n;

	for (n=0; sp = getshipp(n); n++) {
		if (sp->shp_own == 0)
			continue;
		upd_ship(sp, n, etus, getnatp(sp->shp_own));
	}
}

upd_ship(sp, shipno, etus, np)
	register struct shpstr *sp;
	int	shipno;
	register int etus;
	struct	natstr *np;
{
	extern	long pops[];
	struct	sctstr *sectp;
	struct	mchrstr *mp;
	int	vec[I_MAX+1];
	int	cvec[I_MAX+1];
	int	oil_gained;
	int	max_oil;
	int	max_food;
	struct	pchrstr *product;
	char	*resource;
	int	n;

	mp = &mchr[sp->shp_type];
	if (getvec(VT_ITEM, sp, EF_SHIP, vec) <= 0)
		return;
	if (sp->shp_effic < 20) {
		sp->shp_own = 0;
		return;
	}
	sp->shp_effic = min(etus + sp->shp_effic, 100);
	if (mp->m_flags & M_OIL) {
		/*
		 * take care of oil production
		 */
		sectp = getsectp(sp->shp_x, sp->shp_y);
		oil_gained = roundavg((vec[I_CIVIL] * etus / 10000.0)
			* sectp->sct_oil);
		vec[I_OIL] += oil_gained;
		max_oil = vl_find(V_OIL, mp->m_vtype, mp->m_vamt, MAXMCHV);
		if (vec[I_OIL] > max_oil)
			vec[I_OIL] = max_oil;
		product = &pchr[P_OIL];
		if (product->p_nrdep != 0 && oil_gained > 0) {
			resource = ((char *) sectp) + product->p_nrndx;
			*resource -=
				roundavg(oil_gained * product->p_nrdep / 100.0);
		}
	} else if (mp->m_flags & M_FOOD) {
		sectp = getsectp(sp->shp_x, sp->shp_y);
		vec[I_FOOD] += ((vec[I_CIVIL] * etus) / 10000.0)
			* sectp->sct_fertil;
	}
	np->nat_money -= (etus * vec[I_MILIT]) / 12.0;
	if ((n = feed_people(vec, etus)) > 0) {
		wu(0, sp->shp_own, fmt("%d starved on %s #%d\n",
			n, mp->m_name, shipno));
		if (n > 10)
			nreport(sp->shp_own, N_DIE_FAMINE, 0, 1);
	}
	max_food = vl_find(V_FOOD, mp->m_vtype, mp->m_vamt, MAXMCHV);
	if (vec[I_FOOD] > max_food)
		vec[I_FOOD] = max_food;
	/*
	 * do plague stuff.  plague can't break out on ships,
	 * but it can still kill people.
	 */
	getvec(VT_COND, sp, EF_SHIP, cvec);
	if (cvec[C_PSTAGE] > 0) {
		n = plague_people(np, vec, cvec, etus);
		switch (n) {
		case PLG_DYING:
			wu(0, sp->shp_own,
				fmt("PLAGUE deaths reported on %s #%d\n",
				mp->m_name, shipno));
			nreport(sp->shp_own, N_DIE_PLAGUE, 0, 1);
			break;
		case PLG_EXPOSED:
			wu(0, sp->shp_own, fmt("%s #%d battling PLAGUE\n",
				mp->m_name, shipno));
			break;
		case PLG_INCUBATE:
			if (n == cvec[C_PSTAGE])
				break;
			wu(0, sp->shp_own, fmt("Outbreak of PLAGUE on %s #%d!",
				mp->m_name, n));
			nreport(sp->shp_own, N_OUT_PLAGUE, 0, 1);
			break;
		default:
			break;
		}
		putvec(VT_COND, sp, EF_SHIP, cvec);
	}
	putvec(VT_ITEM, sp, EF_SHIP, vec);
	pops[sp->shp_own] += vec[I_CIVIL];
}
