#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/produce.c,v 1.6 89/05/10 02:54:01 muir Exp $";
#endif

/*
 * produce.c
 *
 * produce goodies given what we are supposed to produce.
 * return the cost of production.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "product.h"
#include "nat.h"
#include "file.h"
#include "xy.h"

char	*levelnames[] = { "Technology", "Research", "Education", "Happiness" };

int
produce(np, sp, vec, work)
	struct	natstr *np;
	struct	sctstr *sp;
	int	*vec;
	int	work;
{
	extern	float levels[MAXNOC][4];
	register struct pchrstr *product;
	int	vtype;
	double	p_e;
	double	level_p_e;
	char	*resource;
	int	amt;
	int	actual;
	int	unit_work;
	double	depend;
	int	item;
	int	worker_limit;
	int	material_limit;

	product = &pchr[dchr[sp->sct_type].d_prd];
	if (product == &pchr[0])
		return 0;
	vtype = product->p_type;
	item = vtype &~ VT_ITEM;
	if ((material_limit = materials_cost(product, vec, &unit_work)) <= 0)
		return 0;
	/*
	 * calculate production efficiency.
	 */
	p_e = sp->sct_effic / 100.0;
	if (product->p_nrndx != 0) {
		unit_work++;
		resource = ((char *) sp) + product->p_nrndx;
		p_e = (*resource * p_e) / 100.0;
		if (product->p_nrdep > 0) {
			depend = (*resource * 100.0) / product->p_nrdep;
			if (p_e > depend)
				p_e = depend;
		}
	}
	/*
	 * determine number that can be made with
	 * the available workforce
	 */
	amt = material_limit;
	worker_limit = roundavg(work * p_e / unit_work);
	if (amt > worker_limit)
		amt = worker_limit;
	if (amt == 0)
		return 0;
	level_p_e = 1.0;
	if (product->p_nlndx >= 0) {
		level_p_e = np->nat_level[product->p_nlndx] - product->p_nlmin;
		if (level_p_e < 0.0) {
			wu(0, sp->sct_own,
			   fmt("%s level too low to produce in %s (need %d)\n",
				    levelnames[product->p_nlndx], ownxy(sp),
				    product->p_nlmin));
			return 0;
		}
		level_p_e = level_p_e / (level_p_e + product->p_nllag);
	}
	/*
	 * Adjust produced amount by commodity production ratio
	 */
	amt = roundavg(product->p_effic * 0.01 * amt);
	if (vtype == 0) {
		levels[sp->sct_own][product->p_level] += amt * level_p_e;
		wu(0, sp->sct_own, fmt("%s (%.2f) produced in %s\n",
			product->p_name, amt * level_p_e, ownxy(sp)));
	} else {
		if ((actual = roundavg(level_p_e * amt)) <= 0)
			return 0;
		if (vec[item] >= 999) {
			if (vtype != V_FOOD)
				wu(0, sp->sct_own,
					fmt("%s production backlog in %s\n",
					product->p_name, ownxy(sp)));
			return 0;
		}
		vec[item] += actual;
		if (vec[item] > 999)
			vec[item] = actual;
	}
	/*
	 * Reset produced amount by commodity production ratio
	 */
	amt = amt / (product->p_effic * 0.01);
	materials_charge(product, vec, amt);
	if (product->p_nrdep != 0) {
		/*
		 * lower natural resource in sector depending on
		 * amount produced
		 */
		*resource -= roundavg(product->p_nrdep * amt / 100.0);
		if (*resource < 0)
			*resource = 0;
	}
	np->nat_money -= product->p_cost * amt;
	return unit_work * amt;
}

int
materials_cost(product, vec, costp)
	struct	pchrstr *product;
	register int *vec;
	int	*costp;
{
	register u_char *vp;
	register short *ap;
	register int amt;
	register int cost;
	register int n;
	register u_char *endp;

	amt = 999;
	cost = 0;
	vp = product->p_vtype;
	ap = product->p_vamt;
	endp = product->p_vtype + product->p_nv;
	while (vp < endp) {
		n = vec[*vp++ & ~VT_ITEM] / *ap++;
		if (amt > n)
			amt = n;
		cost += *ap;
	}
	*costp = cost;
	return amt;
}

int
materials_charge(product, vec, amt)
	struct	pchrstr *product;
	register int *vec;
	register int amt;
{
	register u_char *vp;
	register short *ap;
	register u_char *endp;

	vp = product->p_vtype;
	ap = product->p_vamt;
	endp = product->p_vtype + product->p_nv;
	while (vp < endp)
		vec[*vp++ & ~VT_ITEM] -= *ap++ * amt;
}
