#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/plane.c,v 1.6 89/05/10 02:53:56 muir Exp $";
#endif

/*
 * plane.c
 *
 * do "production" for planes -- make more efficient,
 * charge for military, etc.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "plane.h"
#include "ship.h"
#include "nat.h"
#include "file.h"

int
prod_plane(etus)
	int	etus;
{
	register struct plnstr *pp;
	register struct plchrstr *plp;
	struct	natstr *np;
	int	n;
	int	i;
	struct	shpstr *shp;
	struct	sctstr *sp;
	struct	mchrstr *mp;
	int	gas;
	char	*ptr;
	int	type;

	for (n=0; pp = getplanep(n); n++) {
		if (pp->pln_own == 0)
			continue;
		if (pp->pln_effic < 10) {
			pp->pln_own = 0;
			continue;
		}
		shp = 0;
		sp = 0;
		plp = &plchr[pp->pln_type];
		if (pp->pln_ship >= 0) {
			shp = getshipp(pp->pln_ship);
			if (shp == 0 || shp->shp_own != pp->pln_own) {
				pp->pln_own = 0;
				continue;
			}
			mp = &mchr[shp->shp_type];
			if ((plp->pl_flags & P_M) && !(mp->m_flags & M_MSL)) {
				pp->pln_own = 0;
				continue;
			}
			if (!(plp->pl_flags & P_M) && !(mp->m_flags & M_FLY)) {
				pp->pln_own = 0;
				continue;
			}
			ptr = (char *) shp;
			type = EF_SHIP;
		} else {
			sp = getsectp(pp->pln_x, pp->pln_y);
			ptr = (char *) sp;
			type = EF_SECTOR;
		}
		gas = getvar(V_PETROL, ptr, type);
		/* flight pay is 10x the pay received by other military */
		np = getnatp(pp->pln_own);
		np->nat_money -= (plp->pl_crew * 10) / 12;
		if (pp->pln_effic == 100 && chance(.85))
			continue;
		if (pp->pln_flags & PLN_LAUNCHED == PLN_LAUNCHED)
			continue;
		/*
		 * if not a missile, then use gas to practice with.
		 * Missiles just build efficiency normally.
		 */
		if ((plp->pl_flags & P_M) == 0) {
			if (gas < plp->pl_fuel)
				continue;
			putvar(V_PETROL, gas - plp->pl_fuel, sp, type);
		}
		i = pp->pln_effic + etus;
		if (i > 100)
			i = 100;
		pp->pln_effic = i;
	}
}
