#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/main.c,v 1.1 89/05/10 02:53:43 muir Exp $";
#endif

/*
 * main.c
 *
 * main command loop and initialization
 * for empire tm server
 *
 * Dave Pare, 1986
 */

#include "tm.h"
#include "misc.h"
#include "update.h"
#include "bit.h"
#include "nat.h"
#include "file.h"

#include <stdio.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/un.h>
#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/file.h>


char	*program = "update";

long	money[MAXNOC];
long	pops[MAXNOC];

main(argc, argv)
	int	argc;
	char	**argv;
{
	long	now;
	int	etu;
	int	produce;
	int	n;
	struct	natstr *np;

	if (argc != 3) {
		logerror("usage: %s \"produce|mob\" #etus\n", program);
		exit(1);
	}
	time(&now);
	srandom(now);
	produce = 0;
	if (strcmp(argv[1], "produce") == 0)
		produce = 1;
	else if (strcmp(argv[1], "mob") != 0) {
		logerror("no such update type %s\n", argv[1]);
		exit(1);
	}
	if ((etu = atoi(argv[2])) <= 0) {
		logerror("etu value must be positive\n");
		exit(1);
	}
	for (n=getdtablesize(); n >= 0; n--)
		close(n);
	logerror("%s update pid %d", argv[1], getpid());
	ef_open(EF_SECTOR, O_RDWR, EFF_MEM);
	ef_open(EF_SHIP, O_RDWR, EFF_MEM);
	ef_open(EF_PLANE, O_RDWR, EFF_MEM);
	if (produce) {
		/*
		 * set up all the variables which get used in the
		 * sector production routine (for producing education,
		 * happiness, and printing out the state of the nation)
		 */
		ef_open(EF_NEWS, O_RDWR, 0);
		bzero((char *)pops, sizeof(pops));
		for (n=0; n<MAXNOC; n++) {
			money[n] = 0;
			if ((np = getnatp(n)) == 0)
				continue;
			money[n] = np->nat_money;
		}
		prod_ship(etu);
		prod_plane(etu);
		/*
		 * NOTE: prod_sect MUST be last after all other production
		 * in order to have a proper tally of the pop and money
		 * used this update
		 */
		prod_sect(etu);
		age_levels(etu);
		ef_close(EF_NEWS);
		flushwu();
		ef_close(EF_NATION);
	}
	mob_ship(MOB_ETU);
	mob_sect(MOB_ETU);
	mob_plane(MOB_ETU);
	ef_close(EF_SECTOR);
	ef_close(EF_SHIP);
	ef_close(EF_PLANE);
	logerror("End %s update\n", argv[1]);
}
