#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/user.c,v 1.5 89/05/10 02:51:50 muir Exp $";
#endif

/*
 * user.c
 *
 * get a new user
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netdb.h>
#include "sailio.h"
#include "user.h"
#include "tm.h"
#include "misc.h"

struct user *
newuser(d, max)
	int	d;
	int	max;
{
	register struct user *up;
	register int n;
	struct	sockaddr_un un;
	int	foo;
	int	ns;

	foo = sizeof(un);
	ns = accept(d, (struct sockaddr *) &un, &foo);
	if (ns < 0) {
		logerror("new socket accept");
		return 0;
	}
	if (ns >= max) {
		close(ns);
		logerror("new fd %d, max fd %d, no fd's left for new user!",
			ns, max);
		return 0;
	}
	for (n=0, up=users; n < maxusers; n++,up++)
		if (up->u_iop == 0)
			break;
	if (n == maxusers) {
		(void) close(ns);
		logerror("user table full!");
		return 0;
	}
	if ((up->u_iop = sopen(ns)) == 0) {
		(void) close(ns);
		logerror("sopen failed");
		return 0;
	}
	sendnum(up->u_iop, 0, TM_OK);	/* its first packet, thus seq=0 */
	sflush(up->u_iop);
	return up;
}

struct user *
userbypid(pid)
	int	pid;
{
	register struct user *up;
	register int n;

	for (n=0,up=users; n < maxusers; n++,up++) {
		if (up->u_pid == pid)
			return up;
	}
	return 0;
}

struct user *
userbyfd(fd)
	int	fd;
{
	register struct user *up;
	register int n;

	for (n=0,up=users; n < maxusers; n++,up++) {
		if (up->u_iop && up->u_iop->fd == fd)
			return up;
	}
	return 0;
}
