#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/schedule.c,v 1.8 89/05/10 02:51:42 muir Exp $";
#endif

/*
 * schedule.c
 *
 * called by interrupt to either immediately schedule
 * the execution of an update, or to plan on interrupting
 * the currently executing empire job which is blocking
 * execution of the update.
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include "misc.h"
#include <sys/file.h>
#include <netinet/in.h>
#include <errno.h>
#include "sailio.h"
#include "user.h"
#include "tm.h"
#include "update.h"
#include "file.h"


int	blocked = 0;
int	kind = 0;

int
schedule()
{
	extern	long s_p_etu;
	extern	long upd_adj;
	extern	int tm_flags;
	static	int prod_up = 0;
	register int i;
	int	lock;
	long	now;
	long	delta;
	int	pid;

	/*
	 * find out what kind it is.
	 */
	logerror("scheduler");
	if (kind == 0)
		prod_up = update_type();
	if (tm_flags == 0) {
		tm_flags = L_NOLOCK;
		lock = 0;
		for (i=0; i<EF_MAX; i++)
			lock += listlock(i);
		if (lock) {
			blocked = 1;
			(void) alarm(10);
			return;
		}
	} else {
		blocked++;
		lock = 0;
		for (i=0; i<EF_MAX; i++) 
			lock += listlock(i);
		if (lock != 0 && blocked > 0) {
			for (i=0; i<EF_MAX; i++) 
				breaklock(i);
			lock = 0;
		} 
		if (lock != 0) {
			(void) alarm(10);
			return;
		}
	}
	/* 
	 * Do the update, and calculate when the next one will be.
	 * Keep things regular by rounding off the current time, and
	 * adding the time click interval + update adjustment.
	 */
	/*
	 * XXX do something with the pid
	 */
	pid = doupdate(kind, kind == PRODUCE ? PROD_ETU : MOB_ETU);
	delta = update_delta();
	(void) alarm(delta);
	now = time(0) + delta;
	logerror("Next update at %20.20s (%d secs)", ctime(&now), delta);
	kind = 0;
	blocked = 0;
	tm_flags = 0;
}

int
doupdate(kind, etu)
	int	kind;
	int	etu;
{
	extern	char gamedir[];
	int	pid;
	char	av2[32];
	char	*argv[3];
	char	path[1024];

	if ((pid = fork()) < 0) {
		logerror("fork failed");
		return -1;
	}
	if (pid == 0) {
		argv[0] = "update";
		if (kind == PRODUCE)
			argv[1] = "produce";
		else
			argv[1] = "mob";
		sprintf(av2, "%d", etu);
		sprintf(path, "%d/BIN/update", gamedir);
		argv[2] = av2;
		execv(path, argv);
		logerror("exec %s failed", path);
		exit(1);
		/*NOTREACHED*/
	}
	return pid;
}


time_t
update_delta()
{
	time_t	now;
	time_t	delta;

	time(&now);
	delta = (MOB_ETU * s_p_etu) - (now+upd_adj) % (MOB_ETU*s_p_etu);
	return delta;
}

update_type()
{
	extern	char tmstatus[];
	int	fd;
	char	buf[80];
	int	n;
	int	prod_up;

	if ((fd = open(tmstatus, O_RDWR|O_CREAT, 0666)) < 0) {
		logerror("couldn't open tmstatus file (%s)", tmstatus);
		exit(1);
	}
	n = read(fd, buf, sizeof(buf));
	buf[n] = 0;
	prod_up = atoi(buf) + MOB_ETU;
	if (prod_up >= PROD_ETU) {
		kind = PRODUCE;
		prod_up = 0;
	} else {
		kind = MOBILITY;
	}
	(void) lseek(fd, (off_t)0, L_SET);
	(void) sprintf(buf, "%d\n", prod_up);
	(void) write(fd, buf, strlen(buf));
	(void) close(fd);
	return prod_up;
}
