#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/nat.c,v 1.8 89/05/10 02:51:37 muir Exp $";
#endif

/*
 * nat.c
 *
 * perform updates of important, frequently changing
 * nat fields
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "nat.h"
#include "tm.h"
#include "file.h"

/*
 * argi[0]: cmd
 * argi[1]: seqno
 * argi[2]: EF_NATION
 * argi[3]: country #
 * argi[4]: offset
 * argi[5]: index
 * argi[6]: how changed (delta, set)
 * argp[7]: string arg representing new value
 */
int
natmod(argp, argi)
	char	**argp;
	int	argi[];
{
	extern	char **tm_buf;
	register struct fixnat *fp;
	struct	natstr *np;
	char	buf[255];

	/* argi[2] ignored now */
	if ((np = getnatp(argi[3])) == 0) {
		logerror("natmod: bad nation # %d", argi[3]);
		return 0;
	}
	if ((fp = natfield(argi[4])) == 0) {
		logerror("natmod: bad nation field offset %d", argi[4]);
		return 0;
	}
	natassign(fp, SETOFF(np, argi[4]), argp[7], argi[5], argi[6]);

	/* modify <seqno> nationfile natno field index how valuestr */
	sprintf(buf, "%d -1 %d %d %d %d %d \"%s\"\n", TM_MOD, argi[2],
		argi[3], argi[4], argi[5], argi[6], argp[7]);
	if (fp->notify == NF_NOTIFY)
		bcast(buf);
	else
		mcast(buf, argi[3]);
	dw_queue(EF_NATION, argi[3]);
	return 1;
}
