#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/initfiles.c,v 1.5 89/05/10 02:51:28 muir Exp $";
#endif

/*
 * initfiles.c
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "nat.h"
#include "sailio.h"
#include "user.h"
#include "file.h"
#include <sys/file.h>

struct	user *users;
int	maxusers;

initfiles()
{
	extern	int errno;
	struct	natstr *np;
	int	i;

#ifdef sequent
	for (i=16; i<256; i += 16) {
		if (setdtablesize(i+16) < 0)
			break;
	}
	errno = 0;
	logerror("setdtablesize to %d", i);
#endif
	if (ef_open(EF_NATION, O_RDWR, EFF_MEM) < 0) {
		logerror("nation file");
		exit(1);
	}
	/*
	 * set logins of everybody to zero
	 */
	for (i=0; np = getnatp(i); i++)
		np->nat_login = 0;
	if (ef_close(EF_NATION) < 0) {
		logerror("nation file initial write");
		exit(1);
	}
	(void) ef_open(EF_NATION, O_RDWR, EFF_MEM);
	if (ef_open(EF_NEWS, O_RDWR, 0) < 0) {
		logerror("news file initial open");
		exit(1);
	}
	maxusers = getdtablesize();
	users = (struct user *) malloc(sizeof(*users) * maxusers);
	bzero(users, sizeof(*users) * maxusers);
}
