/*
 * nuke.h
 *
 * things having to do with nukes
 *
 * Dave Pare, 1986
 */

#define	N_MAXNUKE	15

struct	nukstr {
	coord	nuk_x;		/* current loc of device */
	coord	nuk_y;
	char	nuk_own;
	char	nuk_n;		/* number of nukes in list */
	short	nuk_uid;
	short	nuk_ship;	/* currently aboard ship */
	short	nuk_trade;	/* index into trade file */
	char	nuk_types[N_MAXNUKE];	/* # of nukes in sector of given type */
};

struct nchrstr {
	char *n_name;		/* warhead unit name */
	int n_lcm;		/* costs to build */
	int n_hcm;
	int n_oil;
	int n_rad;
	int n_blast;		/* blast radius */
	int n_dam;		/* damage at center */
	int n_cost;
	int n_tech;		/* tech needed to build */
	int n_weight;
	int n_flags;		/* description of capability */
};

#define getnuke(n, p) \
	ef_nbread(EF_NUKE, n, (caddr_t)p)
#define putnuke(n, p) \
	ef_nbwrite(EF_NUKE, n, (caddr_t)p)
#define getnukep(n) \
	(struct nukstr *) ef_ptr(EF_NUKE, n)

extern  struct nchrstr nchr[];
extern	int nuk_maxno;
