/*
 * nat.h
 *
 * things having to do with nations
 *
 * from PSL Empire, 1985
 */

#define	MAXNOR		12              /* max # realms */

struct	boundstr {
	short	b_xl, b_xh;		/* horizontal bounds */
	short	b_yl, b_yh;		/* vertical bounds */
};

struct	natstr {
	char	nat_cnam[20];		/* country name */
	char	nat_pnam[20];		/* representative */
	coord	nat_xcap, nat_ycap;	/* cap location in abs coords */
	coord	nat_xorg, nat_yorg;	/* origin location in abs coords */
	char	nat_stat;		/* inuse, norm, god, abs */
	char	nat_dayno;		/* day of the year mod 128 */
	char	nat_login;		/* logged in or not? */
	int	nat_tgms;		/* # of telegrams to be announced */
	int	nat_minused;		/* number of minutes used today */
	int	nat_btu;		/* bureaucratic time units */
	long	nat_reserve;		/* military reserves */
	long	nat_money;		/* moola */
	time_t	nat_date;		/* last logoff */
	time_t	nat_newstim;		/* date news last read */
	float	nat_level[4];		/* technology, etc */
	struct	boundstr nat_b[MAXNOR];	/* realm bounds */
	short	nat_relate[MAXNOC/8];	/* two bits for each other country */
};

	/* nation status types */
#define STAT_INUSE	bit(0)		/* cnum in use */
#define STAT_NORM	bit(1)		/* normal country */
#define STAT_GOD	bit(2)		/* deity powers */
#define STAT_ABS	bit(3)		/* abs coords */
#define STAT_NEW	bit(4)		/* just initialized */

	/* nstat values */
#define VIS		STAT_INUSE
#define	NORM		(STAT_INUSE|STAT_NORM)
#define	GOD		(STAT_INUSE|STAT_GOD)
#define	CAP		bit(5)
#define	MONEY		bit(6)

	/* nation relation codes */
#define	NEUTRAL		0
#define	ALLIED		1
#define	HOSTILE		2
#define	AT_WAR		3

#define	NAT_TLEV	0
#define	NAT_RLEV	1
#define	NAT_ELEV	2
#define	NAT_HLEV	3

#define	NF_DELTA	1
#define NF_SET		2

	/* yuck; nation modify macros to send stuff to tm */

#define	NAT_DELTA(field, coun, value) \
	(nat_value(OFFSET(natstr, field), coun, 0, NF_DELTA, value))
#define	NAT_SET(field, coun, value) \
	(nat_value(OFFSET(natstr, field), coun, 0, NF_SET, value))
#define	NAT_SETARY(field, coun, i, value) \
	(nat_value(OFFSET(natstr, field), coun, i, NF_SET, value))
#define	NAT_DELTARY(field, coun, i, value) \
	(nat_value(OFFSET(natstr, field), coun, i, NF_DELTA, value))

#define	NF_CHAR		1
#define	NF_SHORT	2
#define	NF_LONG		3
#define	NF_STRING	4
#define	NF_FLOAT	5
#define	NF_DOUBLE	6
#define	NF_BOUND	7

#define NF_NOTIFY	1
#define NF_PRIVATE	2

struct fixnat {
	int type;
	int index;
	int notify;
	int offset;
};

/* procedures relating to nation stuff */

#define getnatp(n) \
	(struct natstr *) ef_ptr(EF_NATION, n)

extern	double techfact();
extern	double tfact();
extern	double reltech();
extern	double multread();

extern	char *natstate();
extern	char *cname();
extern	char *relatename();
extern	struct fixnat *natfield();

extern	int cnum;
extern	int owner;
extern	int nstat;
extern	double dolcost;
extern	int nbtu;
extern	int broke;
extern	int maxcno;
extern	int maxnoc;
