/*
 * misc.h
 *
 * defines which don't really belong anywhere,
 * but have to go somewhere!
 *
 */

#ifndef major
#include <sys/types.h>
#endif
#include <strings.h>

#define MAXNOC		128

#define WORLD_X		256
#define WORLD_Y		256

typedef	short coord;		/* also change NSC_COORD in nsc.h */

/*
 * watch it; your compiler might not like this.
 * If you think this is bogus, look at /usr/include/struct.h
 */
#define	OFFSET(stype, oset) ((int)(&(((struct stype *)0)->oset)))
#define	SETOFF(sinst, oset) ((char *) (sinst) + (oset))

#ifndef bit
#define	bit(x)		(1<<(x))
#endif

#define hours(x)	(60*60*(x))
#define days(x)		(60*60*24*(x))

typedef void (*voidfunc)();

	/* return codes from command routines */
#define	RET_OK		0   /* command completed sucessfully */
#define	RET_FAIL	1   /* command completed unsucessfully [?] */
#define	RET_SYN		2   /* syntax error in command */
#define	RET_SYS		3   /* system error (missing file, etc) */

/*
 * references to library functions which aren't related to any
 * particular object, and are of general interest
 */
extern	long random();

extern	double dmax();
extern	double dmin();

extern	char *fmt(/* char * */);
extern	char *copy();
extern	char *numstr();
extern	char *esplur();
extern	char *splur();
extern	char *iesplur();
extern	char *plur();
extern	char *getstarg();
extern	char *getstring();

/*
 * frequently used libc functions
 */

extern	char *malloc();
extern	char *calloc();

#ifdef sparc
#include <alloca.h>
#else
extern	char *alloca();
#endif

extern	char *ctime();
extern	char *strncpy();
extern	char *strcpy();
extern	char *index();
extern	char *rindex();

extern	time_t time();
extern	double atof();
