/*
 * loan.h
 *
 * things having to do with loans.
 *
 * from PSL Empire, 1985
 */

#define	MAXLOAN		100000
#define SECS_PER_DAY	(60*60*24)

struct	lonstr {
	char	l_loner;	/* loan shark */
	char	l_lonee;	/* sucker */
	short	l_sell;		/* pointer to trade file */
	int	l_irate;	/* interest rate */
	int	l_ldur;		/* intended duration */
	long	l_amtpaid;	/* amount paid so far */
	long	l_amtdue;	/* amount still owed */
	time_t	l_lastpay;	/* date of most recent payment */
	time_t	l_duedate;	/* date after which interest doubles, etc */
};

#define getloan(n, lp) \
	ef_nbread(EF_LOAN, n, (caddr_t)lp)
#define putloan(n, lp) \
	ef_nbwrite(EF_LOAN, n, (caddr_t)lp)
#define getloanp(n) \
	(struct lonstr *) ef_ptr(EF_LOAN, n)
