/*
 * file.h
 *
 * Describes Empire files and their contents.
 *
 */

struct empfile {
	char *name;		/* file name */
	int flags;		/* misc stuff */
	int mode;		/* O_flags */
	int size;		/* size of object */
	int (*postread)();	/* specific massage routines for items */
	int (*prewrite)();
	int varoffs[3];		/* struct offs for nv, vtype, vamt */
	int maxvars;		/* max # vars for type */
	int fd;			/* file descriptor */
	int baseid;		/* starting item in cache */
	int cids;		/* # ids in cache */
	int csize;		/* size of cache in bytes */
	caddr_t cache;		/* pointer to cache */
	int fids;		/* # of ids in file */
	struct castr *cadef;	/* ca defs selection list */
};

#define EFF_COM		bit(0)	/* item has commodities attached */
#define EFF_XY		bit(1)	/* has location */
#define EFF_MEM		bit(2)	/* stored entirely in-memory */

#define EF_SECTOR	0
#define EF_NEWS		1
#define EF_LOAN		2
#define EF_SHIP		3
#define EF_PLANE	4
#define EF_TREATY	5
#define EF_NUKE		6
#define EF_TRADE	7
#define EF_POWER	8
#define EF_NATION	9
#define EF_MAX		10

extern	struct castr *ef_cadef();
extern	int ef_read();
extern	int ef_nbread();
extern	char *ef_ptr();
extern	struct range worldrange;
extern	struct empfile empfile[];
