
/*
 * bit.h
 *
 * since every operating system seems to have its very own way
 * of dealing with variable-sized bit fields, why not us too?
 *
 */


typedef unsigned int	bit_mask;
typedef bit_mask	*bit_fdmask;

#ifndef bit
#define	bit(x) 		(1 << (x))
#endif

/*
 * File descriptor bit manipulation macros for use with select(2)
 */
#define	BIT_NBBY	8
#define	BIT_BITSPERMASK	(sizeof(bit_mask) * BIT_NBBY)

#define BIT_SETB(a,b)	\
	((b)[(a)/BIT_BITSPERMASK] |= 1 << ((a) % BIT_BITSPERMASK))
#define BIT_CLRB(a,b)	\
	((b)[(a)/BIT_BITSPERMASK] &= ~(1<< ((a) % BIT_BITSPERMASK)))
#define BIT_ISSETB(a,b)	\
	((b)[(a)/BIT_BITSPERMASK] & (1<< ((a) % BIT_BITSPERMASK)))
#define BIT_ISCLRB(a,b)	\
	(((b)[(a)/BIT_BITSPERMASK] & (1<<((a) % BIT_BITSPERMASK))) == 0)

extern	bit_fdmask	bit_newfdmask();
