static char *RCSid = "$Header: misc.c,v 1.4 88/04/01 04:47:37 muir Locked $";

/*
 * $Log:	misc.c,v $
 * Revision 1.4  88/04/01  04:47:37  muir
 * rcsid now at top
 * 
 */

/*
 * misc.c
 *
 * misc subroutines
 *
 * from PSL Empire, 1985
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

int
xwrap(x)
	int	x;
{
	extern	int w_xsize;
	register int q;
	register int wxh;

	wxh = w_xsize >> 1;
	q = x + wxh;
	while (q <= 0)
		q += w_xsize;
	return (((q-1) % w_xsize) + 1 - wxh);
}

int
ywrap(y)
	int	y;
{
	extern	int w_ysize;
	register int q;
	register int wyh;

	wyh = w_ysize >> 1;
	q = y + wyh;
	while (q <= 0)
		q += w_ysize;
	return (((q-1) % w_ysize) + 1 - wyh);
}

int
fsize(fd)
	int	fd;
{
	struct	stat statb;

	if (fstat(fd, &statb) < 0)
		return 0;
	return statb.st_size;
}

int
min(a, b)
	int	a;
	int	b;
{
	if (a < b)
		return a;
	return b;
}

char *
copy(s1, s2)
	register char *s1;
	register char *s2;
{
	while (*s2++ = *s1++)
		;
	s2--;
	return s2;
}

char *
fmt(fmt, args)
	char	*fmt;
	int	args;
{
	static	char buf[255];
#ifdef hpux
	FILE _strbuf;
#else
	struct _iobuf _strbuf;
#endif

#ifdef hpux
	_strbuf._flag = _IOWRT;
#else
	_strbuf._flag = _IOWRT+_IOSTRG;
#endif
	_strbuf._ptr = buf;
	_strbuf._cnt = 32767;
	_doprnt(fmt, &args, &_strbuf);
	putc('\0', &_strbuf);
	return buf;
}
