static char *RCSid = "$Header: cmds.c,v 1.4 88/04/01 04:46:28 muir Locked $";

/*
 * $Log:	cmds.c,v $
 * Revision 1.4  88/04/01  04:46:28  muir
 * rcsid now at top
 * 
 */

/*
 * cmds.c
 *
 * identify remote host, user, et al..
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "defs.h"
#include "sailio.h"
#include "user.h"

extern	struct user users[];

int
user(up, name)
	struct	user *up;
	char	*name;
{
	extern	void sendclient();
	extern	char *strcpy();
	char	buf[80];

	if (*name == 0) {
		sendclient(up->u_iop, C_CMDERR, "arg error");
		return 0;
	}
	sendclient(up->u_iop, C_CMDOK, sprintf(buf, "hello %s", name));
	(void) strcpy(up->u_remuser, name);
	return 0;
}

quit(up)
	struct	user *up;
{
	extern	struct user *deluser();
	extern	void sendclient();

	sendclient(up->u_iop, C_EXIT, "so long");
	sflush(up->u_iop);
	sclose(up->u_iop);
	deluser(up);
	return 1;
}

int
coun(up, name)
	struct	user *up;
	char	*name;
{
	extern	struct user *userbycountry();
	extern	void sendclient();
	extern	char *strcpy();
	char	buf[80];
	int	coun;

	if (*name == 0) {
		sendclient(up->u_iop, C_CMDERR, "arg error");
		return 0;
	}
	if ((coun = natbyname(name)) < 0) {
		sendclient(up->u_iop, C_CMDERR, "no such country");
		return 0;
	}
	up->u_country = coun;
	*up->u_password = 0;
	sendclient(up->u_iop, C_CMDOK, sprintf(buf, "country %s ok", name));
	(void) strcpy(up->u_countryname, name);
	return 0;
}

int
pass(up, passwd)
	struct	user *up;
	char	*passwd;
{
	extern	void sendclient();
	extern	char *strcpy();
	char	buf[80];

	if (*passwd == 0) {
		sendclient(up->u_iop, C_CMDERR, "arg error");
		return 0;
	}
	if (*up->u_countryname == 0) {
		sendclient(up->u_iop, C_CMDERR, "need a country name first!");
		return 0;
	}
	if (strlen(passwd)>30) *(passwd+29)=0;
	if (natpass(up->u_country, passwd)) {
		strcpy(up->u_password, passwd);
		sendclient(up->u_iop, C_CMDOK, "password ok");
		servlog(sprintf(buf, "%s@%s using country %s",
			up->u_remuser, up->u_remhost, up->u_countryname));
	} else {
		sendclient(up->u_iop, C_CMDERR, "password bad, logging entry");
		servlog(sprintf(buf, "%s@%s tried country %s with %s",
			up->u_remuser, up->u_remhost, up->u_countryname,
			passwd));
	}
	return 0;
}

int
play(up)
	struct	user *up;
{
	extern	void sendclient();
	extern	char empire[];
	char	country[40];
	char	buf[120];
	char	ruid[40];
	struct	user *cp;
	int	pid;
	int	i;
	int	val = 1;
#ifdef KILLSERVER
	extern	int killfd;
	extern 	int killd;
	int	codenum;
#endif

	if (*up->u_password == 0) {
		sendclient(up->u_iop, C_CMDERR, "no password entered");
		return 0;
	}
	if (up->u_country < 0) {
		sendclient(up->u_iop, C_CMDERR, "no country entered");
		return 0;
	}
	if ((cp = userbycountry(up)) != 0) {
		sprintf(buf, "country in use by %s@%s (pid %d)",
			cp->u_remuser, cp->u_remhost, cp->u_pid);
		sendclient(up->u_iop, C_EXIT, buf);
		return 0;
	}
	if (access(empire, X_OK) == -1) {
		sprintf(buf, "cannot execute %s!", empire);
		sendclient(up->u_iop, C_EXIT, buf);
		return 0;
	}
#ifdef KILLSERVER
#ifdef hpux
	codenum = rand();
#else
	codenum = random();
#endif
#endif
	pid = fork();
	if (pid == -1) {
		servlog("fork error");
		sendclient(up->u_iop, C_DATA, "fork error on server end");
		return 0;
	}
	if (pid != 0) {
		up->u_pid = pid;
		sflush(up->u_iop);
		sclose(up->u_iop);
		up->u_iop = 0;
		return 1;
	}
#ifdef KILLSERVER
	{ 
		int a[2];

		a[0] = getpid();
		a[1] = codenum;
		write(killfd,a,sizeof(a));
		kill(killd,SIGURG);
		close(killfd);
	}
#endif
	if (setsockopt(up->u_iop->fd, SOL_SOCKET, SO_KEEPALIVE,
		&val, sizeof(val)) < 0)
		servlog("play setsockopt error");
	dup2(up->u_iop->fd, 0);
	dup2(up->u_iop->fd, 1);
	dup2(up->u_iop->fd, 2);
#ifdef hpux
	for (i=3; i<_NFILE; i++)
#else
	for (i=3; i<getdtablesize(); i++)
#endif
		close(i);
	sprintf(country, "%d", up->u_country);
	strcpy(ruid, "5");
#ifdef KILLSERVER
	sprintf(buf,"%d",codenum);
	execl(empire, "empire", country, ruid, buf, 0);
#else
	execl(empire, "empire", country, ruid, 0);
#endif
	servlog("cannot exec empire!");
	write(1, "201 cannot exec empire!",
		sizeof("201 cannot exec empire!"));
	exit(1);
	return 0;
}

list(us)
	struct	user *us;
{
	register struct user *up;
	char	buf[80];

	if (us->u_country != 0 || *up->u_password == 0) {
		sendclient(us->u_iop, C_CMDERR, "Permission denied");
		return 0;
	}
	sendclient(us->u_iop, C_DATA, "user@host\tcountry\tcmd\tstatus\tpid");
	foreachuser (up) {
		if (*up->u_remhost == 0)
			continue;
		sprintf(buf, "%s@%s\t%s\t%s\t%s\t%d",
			*up->u_remuser == 0 ? "???" : up->u_remuser,
			up->u_remhost,
			*up->u_countryname == 0 ? "???" : up->u_countryname,
			up->u_cmd == 0 ? "???" : up->u_cmd,
			up->u_pid > 0 ? "logged in" : "logging in",
			up->u_pid);
		sendclient(us->u_iop, C_DATA, buf);
	}
	sendclient(us->u_iop, C_DATA, 0);
	return 0;
}

int	iswatching;

wat(up)
	register struct user *up;
{
	char	buf[80];

	if (up->u_stat == STAT_WATCH) {
		up->u_stat = STAT_NORM;
		iswatching--;
		return 0;
	}
	iswatching++;
	list(up);
	up->u_stat = STAT_WATCH;
	return 0;
}
