static char *RCSid = "$Header: quit.c,v 1.0 88/04/01 04:35:24 muir Locked $";

/*
 * quit.c
 *
 * Quit the game.
 *
 */

#include "misc.h"
#include "com.h"
#include "nat.h"

quit()
{
	extern	long logintime;
	extern	long curup;

	/*
	 * enforce minimum login time of one minute
	 * by charging for the minute even though
	 * less time was actually accrued.
	 */
#ifndef	RANDOMTIME
	NAT_DELTA(nat_minused, cnum, 1);
#else
	if (curup - logintime < 60 ) {
		int logtime, rand;

		rnd = random() % 60;
		logtime = curup - logintime;
		if (logtime == 0)
			logtime = (random() % 15) + 1;
		if (rand < 2)
			rand = random() % logtime;
		pr(fmt("time: %d seconds, random: %d\n", logtime, rand));
		if (logtime >= rand) {	
			pr ("charged 1 min\n");
			NAT_DELTA(nat_minused, cnum, 1);
		} else {
			pr ("got away for nothing\n");
		}
	}
#endif /* RANDOMTIME */
	pr("Bye-bye\n");
	bye_bye(0);
	/*NOTREACHED*/
}
