static char *RCSid = "$Header: oob.c,v 1.4 88/04/01 04:41:09 muir Locked $";

/*
 * oob.c
 *
 * handle out of band messages
 *
 * Dave Pare, 1986
 */

#include "defs.h"
#include "misc.h"

#include <stdio.h>
#include <setjmp.h>
#include <sys/socket.h>
#include <signal.h>
#include <sys/ioctl.h>
#ifdef hpux
#include <sys/termio.h>
#endif

voidfunc sigstatus;

oob()
{
	extern	int errno;
	extern	jmp_buf env;
	int	atmark;
	char	waste[4096];

	ioflush();
#ifndef KILLSERVER
	for (;;) {
		int rv;
		if (ioctl(0, SIOCATMARK, &atmark) < 0) {
			perror("ioctl");
			break;
		}
		if (atmark)
			break;
		rv = read(0, waste, sizeof (waste));
		for(atmark = 0; atmark < rv; atmark++)
			if (waste[atmark] == '\01') rv = -1;
		if (rv <= 0)
			break;
		pr("in loop\n");
	}
	/*
	atmark = recv(0, waste, sizeof(waste), MSG_OOB);
	sprintf(waste,"past loop %d\n",atmark);
	pr(waste);
	*/
#endif KILLSERVER
	outid(C_ABORT);
	puts("");
	if (sigstatus == (voidfunc)SIG_DFL) {
		outid(C_SIGREL);
		puts("");
		longjmp(env, 1);
	}
	/*
	 * signals are "blocked"
	 */
	outid(C_SIGHOLD);
	puts("");
	pr("Interrupts blocked\n");
	(void) fflush(stdout);
	return 0;
}

ioflush()
{
	int	out = 1+1;

	/*
	 * throw away all the i/o queued up
	 */
	stdout->_cnt = 0;
	stdout->_ptr = stdout->_base;
	stdin->_cnt = 0;
	stdin->_ptr = stdin->_base;
#ifdef hpux
	(void) ioctl(0, TCFLSH, out);
#else
	(void) ioctl(0, TIOCFLUSH, (char *)&out);
#endif
}

/*
 * SIGHUP is recieved when server wants to break lock on
 * a particular empire process.
 * This just causes a longjmp back to cmd level.
 * notify client process by a msg_oob, followed by
 * the notification.
 */
hup()
{
	extern	jmp_buf env;
	char	c;

	ioflush();
	c = 0;
#ifndef KILLSERVER
	(void) send(1, &c, sizeof(c), MSG_OOB);
#endif
	pr("Server broke lock...command aborted.\n");
	longjmp(env, 1);
}

/*
 * gencore lets the player know empire puked, then drops a core
 * in the empire home directory.
 *
 * I won't natter about how this should never happen...
 */
gencore(sig)
	int	sig;
{
	extern	char *fmt();

	(void) signal(SIGILL, SIG_DFL);
	(void) signal(SIGIOT, SIG_DFL);
	pr("\n");
	outid(C_EXIT);
	pr(fmt("Empire died on signal %d!\n", sig));
	(void) fflush(stdout);
	_cleanup();
	abort();
}

sigsetup()
{
	(void) signal(SIGPIPE, SIG_IGN);
	(void) signal(SIGHUP, hup);
#ifdef KILLSERVER
	(void) signal(SIGURG, SIG_IGN);
#else
	(void) signal(SIGURG, oob);
#endif
	(void) signal(SIGFPE, gencore);
	(void) signal(SIGILL, gencore);
	(void) signal(SIGBUS, gencore);
	(void) signal(SIGSEGV, gencore);
	(void) signal(SIGQUIT, gencore);
#ifdef KILLSERVER
	(void) signal(SIGUSR1, oob);
	(void) signal(SIGUSR2, SIG_IGN);
#endif
	sigstatus = (voidfunc) SIG_DFL;
}

/*
 * user interrupts should ONLY come via SIGURG and the
 * OOB messages on the input socket (fd 0).  Therefore,
 * to "block them out", we just need to tell the
 * client that we aren't going to longjmp.
 */
sigsave() {
	sigstatus = (voidfunc) SIG_IGN;
}

sigrest() {
	sigstatus = (voidfunc) SIG_DFL;
}
