static char *RCSid = "$Header: main.c,v 1.10 88/12/16 19:51:33 muir Locked $";

/*
 * main.c
 *
 * main command loop for Empire
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include <stdio.h>
#include <setjmp.h>
#include <sys/time.h>
#include <fcntl.h>
#include <signal.h>
#ifdef OLDSOCKETS
#include <sys/socket.h>
#else
#include <sys/ioctl.h>
#endif
#include "defs.h"

#include "var.h"
#undef QUIT
#include "com.h"
#include "nat.h"
#include "sect.h"
#include "deity.h"
#include "file.h"

#define NULL	0

jmp_buf	env;
char	_sobuf[4096];
long	logintime;
char	combuf[1024];
char	*argp[64];
char	*condarg;
int	istty;

char	*program = "client";

main(argc, argv)
	int	argc;
	char	**argv;
{
	extern	struct tm *localtime();
	extern	char client_version[];
	extern	int locks;
	extern	long curup;
	extern	int minleft;
	extern	int btused;
	extern	int m_m_p_d;
	int	minutes;
	int	visitor = 0;
	struct	natstr *natp;
	struct	sctstr sect;
	time_t	lasttime;

	time(&logintime);
	istty = isatty(0);
	lasttime = logintime;
	(void) time(&curup);
	(void) srandom(curup >> 16);
	setbuf(stdout, _sobuf);
#ifndef hpux
	(void) fcntl(0, F_SETOWN, getpid());
#endif
#ifdef OLDSOCKETS
	/* undocumented means to get old 4.2 sockets to receive SIGURG
	   and SIGIO signals */
	{
		int pid = -getpid();
		if (ioctl(0, SIOCSPGRP, (char *) &pid) < 0) {
			perror("ioctl for pgrp");
			bye_bye(1);
		}
	}
#endif OLDSOCKETS
	sigsetup();
	showvers(client_version);
#ifdef KILLSERVER
	outid(C_KILLCODE);
	puts(argv[2]);
	for (n=strlen(argv[2])-1; n >= 0; --n)
		argv[2][n] = ' ';
	if (argc != 3) {
#else
	if (argc != 2) {
#endif
		pr("Empire problems!  Need country #\n");
		bye_bye(1);
	}
	cnum = atoi(argv[1]);
	if (cnum < 0 || cnum > maxcno) {
		pr("Sorry, Empire problems.\n");
		bye_bye(2);
	}
	/*
	 * get rid of the country number
	 */
	argv[1][1] = ' ';
	argv[1][0] = ' ';
	if (!tm_connect()) {
		logerror("Can't connect to the transaction manager!");
		(void) fflush(stdout);
		bye_bye(0);
	}
	init_files();
	init_nats();
	natp = getnatp(cnum);
	if (!gamehours(curup) && (natp->nat_stat & STAT_GOD) == 0) {
		pr("Empire hours restriction in force\n");
		fflush(stdout);
		bye_bye(0);
	}
	visitor = (natp->nat_stat & (STAT_NORM|STAT_GOD)) == 0;
	NAT_DELTA(nat_login, cnum, 1);
	dolcost = 0.0;
	tm_sync(2000);
	/*
	 * empire main loop; plenty of system calls per iteration!
	 * time(&curup), getsect(0,0), read(tm), read(gamedown),
	 * read(stdin, cmdbuf).
	 */
jump:
	sigrest();
	if (setjmp(env)) {
		outid(C_DATA);
		putc('\n', stdout);
		outid(C_ABORT);
		puts("Aborted");
		ef_unlock(EF_TRADE);
		(void) fflush(stdout);
	}
	natp = getnatp(cnum);
	if (dolcost != 0.0) {
		if (dolcost > 100.0)
			pr(fmt("That just cost you $%.2f\n", dolcost));
		else if (dolcost < -100.0)
			pr(fmt("You just made $%.2f\n", -dolcost));
		if (natp->nat_money < dolcost && !broke) {
			broke = 1;
			nstat &= ~MONEY;
			pr("You are now broke; industries are on strike.\n");
		} else if (broke && natp->nat_money - dolcost > 0) {
			broke = 0;
			nstat |= MONEY;
			pr(fmt("You are	no longer broke!\n"));
		}
		NAT_DELTA(nat_money, cnum, -(int)(dolcost+0.5));
		dolcost = 0.0;
	}
	getsect(natp->nat_xcap, natp->nat_ycap, &sect);
	if ((sect.sct_type == SCT_CAPIT || sect.sct_type == SCT_SANCT) &&
	    sect.sct_own == cnum)
		nstat |= CAP;
	else
		nstat &= ~CAP;
	ncomstat = nstat;
	(void) time(&curup);
	minutes = (curup - lasttime) / 60;
	if (minutes > 0) {
		minleft -= minutes;
		if (minleft <= 0) {
			/*
			 * countdown timer "minleft" has expired.
			 * either day change, or hours restriction
			 */
			daychange(curup);
			if (!gamehours(curup)) {
				pr("Empire hours restriction in force\n");
				quit();
			}
		}
		lasttime += minutes * 60;
		NAT_DELTA(nat_minused, cnum, minutes);
	}
	if ((nstat & NORM) && natp->nat_minused > m_m_p_d) {
		pr("Max minutes per day limit exceeded.\n");
		ncomstat = VIS;
	}
	if (btused) {
		NAT_DELTA(nat_btu, cnum, -btused);
		btused = 0;
	}
	if (natp->nat_tgms > 0) {
		if (natp->nat_tgms == 1)
			pr("You have a new telegram waiting ...\n");
		else
			pr(fmt("You have %s new telegrams waiting ...\n",
				numstr(natp->nat_tgms)));
		NAT_DELTA(nat_tgms, cnum, -natp->nat_tgms);
	}
	if (!visitor && !god && (nstat & CAP) == 0)
		pr("You lost your capital... better designate one\n");
	/*
	 * either choice will flush buffer to tm, and then
	 * get updated nat entries (among other things)
	 */
	if (locks) {
		tm_unlock(locks);
		locks = 0;
	} else {
		tm_sync(450);
	}
	if (gamedown() && !god)
		quit();
	/*
	 * when getcommand returns -1, it means CTLD was sent.
	 */
	if (getcommand(combuf) == -1)
		quit();
	if (parse(combuf, argp, &condarg, 0) < 0) {
		pr("See \"info syntax\"?\n");
		goto jump;
	}
	if (dispatch() < 0)
		pr("Try \"list of commands\", \"info commands\" or \"info\"\n");
	goto jump;
}
