#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/gen/RCS/copy.c,v 1.7 89/05/10 03:54:02 muir Exp $";
#endif

/*
 * copy.c
 *
 * copy and return pointer to end of copied string.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"

char *
copy(s1, s2)
	register char *s1;
	register char *s2;
{
	while (*s2++ = *s1++)
		;
	return s2 - 1;
}

#ifdef hpux
#include <memory.h>

bzero(ptr, len)
	char	*ptr;
	int	len;
{
	memset(ptr, 0, len);
}

bcopy(src, dst, len)
	char	*src;
	char	*dst;
	int	len;
{
	memcpy(dst, src, len);
}
#endif

/*
 * space-fill a map or radar scan
 */
blankfill(ptr, diameter, arraylen)
	char	*ptr;
	int	diameter;
	int	arraylen;
{
	register char *p;
	register int row;
	register int col;

	if (diameter > arraylen) {
		logerror("blankfill: array size is %d, diameter is %d",
			arraylen, diameter);
		return;
	}
	for (row=0; row<diameter; row++) {
		p = ptr + row*arraylen;
		col = diameter*2;
		while (--col >= 0)
			*p++ = ' ';
		*p = 0;
	}
}
