#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/natfield.c,v 1.1 89/05/10 03:56:20 muir Exp $";
#endif

/*
 * natfield.c
 *
 * Return definition of nation structure fields.
 * Assign values to in-memory copy of nation structure.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include <sys/file.h>
#include "nat.h"
#include "sailio.h"
#include "file.h"
#include "tm.h"

#define NF_NOTIFY	1
#define NF_PRIVATE	2

struct fixnat fixnat[] = {
	NF_STRING,	1,	NF_NOTIFY,	OFFSET(natstr, nat_cnam[0]),
	NF_STRING,	1,	NF_PRIVATE,	OFFSET(natstr, nat_pnam[0]),
	NF_CHAR,	1,	NF_PRIVATE, 	OFFSET(natstr, nat_login),
	NF_SHORT,	1,	NF_NOTIFY,	OFFSET(natstr, nat_xcap),
	NF_SHORT,	1,	NF_NOTIFY,	OFFSET(natstr, nat_ycap),
	NF_SHORT,	1,	NF_NOTIFY,	OFFSET(natstr, nat_xorg),
	NF_SHORT,	1,	NF_NOTIFY,	OFFSET(natstr, nat_yorg),
	NF_CHAR,	1,	NF_NOTIFY,	OFFSET(natstr, nat_stat),
	NF_CHAR,	1,	NF_PRIVATE,	OFFSET(natstr, nat_dayno),
	NF_LONG,	1,	NF_PRIVATE,	OFFSET(natstr, nat_btu),
	NF_LONG,	1,	NF_PRIVATE,	OFFSET(natstr, nat_reserve),
	NF_LONG,	1,	NF_PRIVATE,	OFFSET(natstr, nat_tgms),
	NF_LONG,	1,	NF_PRIVATE,	OFFSET(natstr, nat_minused),
	NF_LONG,	1,	NF_PRIVATE,	OFFSET(natstr, nat_date),
	NF_LONG,	1,	NF_NOTIFY,	OFFSET(natstr, nat_money),
	NF_LONG,	1,	NF_PRIVATE,	OFFSET(natstr, nat_newstim),
	NF_SHORT,	MAXNOC/8,NF_NOTIFY,	OFFSET(natstr, nat_relate[0]),
	NF_BOUND,	MAXNOR,	NF_PRIVATE,	OFFSET(natstr, nat_b[0]),
	NF_FLOAT,	4,	NF_PRIVATE,	OFFSET(natstr, nat_level[0]),
	0,		0,	0,		-1,
};

struct fixnat *
natfield(offset)
	int	offset;
{
	register struct fixnat *fp;

	for (fp = fixnat; fp->offset >= 0; fp++) {
		if (fp->offset == offset)
			return fp;
	}
	return 0;
}

int
natassign(fp, addr, valp, ind, how)
	struct	fixnat *fp;
	union {
		char *ch;
		short *sh;
		long *lo;
		float *fl;
		double *dbl;
		struct boundstr *bnd;
		char *str;
	} addr;
	char	*valp;
	int	ind;
	int	how;
{
	switch (fp->type) {
	case NF_CHAR:
		if (how == NF_DELTA)
			addr.ch[ind] += atoi(valp);
		else
			addr.ch[ind] = atoi(valp);
		break;
	case NF_SHORT:
		if (how == NF_DELTA)
			addr.sh[ind] += atoi(valp);
		else
			addr.sh[ind] = atoi(valp);
		break;
	case NF_LONG:
		if (how == NF_DELTA)
			addr.lo[ind] += atoi(valp);
		else
			addr.lo[ind] = atoi(valp);
		break;
	case NF_FLOAT:
		if (how == NF_DELTA)
			addr.fl[ind] += atof(valp);
		else
			addr.fl[ind] = atof(valp);
		break;
	case NF_DOUBLE:
		if (how == NF_DELTA)
			addr.dbl[ind] += atof(valp);
		else
			addr.dbl[ind] = atof(valp);
		break;
	case NF_STRING:
		strcpy(addr.str, valp);
		break;
	case NF_BOUND:
		if (*valp)
			addr.bnd[ind].b_xl = atoip(&valp);
		if (*valp)
			addr.bnd[ind].b_xh = atoip(&valp);
		if (*valp)
			addr.bnd[ind].b_yl = atoip(&valp);
		if (*valp)
			addr.bnd[ind].b_yh = atoip(&valp);
		break;
	default:
		logerror("bad case value %d", fp->type);
	}
}
