#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/log.c,v 1.1 89/05/10 03:56:17 muir Exp $";
#endif

/*
 * erlog.c
 *
 * Log an empire error to a file.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include <errno.h>
#include <sys/file.h>
#include <varargs.h>
#include "deity.h"

logerror(va_alist)
	va_dcl
{
	extern	char *program;
	extern	char logfil[];
	extern	char *sys_errlist[];
	extern	int errno;
	va_list	list;
	long	now;
	char	buf[512];
	char	buf1[512];
	char	*fmt;
	int	logf;
	char	*error;

	va_start(list);
	fmt = va_arg(list, char *);
	vsprintf(buf, fmt, list);
	time(&now);
	error = "log";
	if (errno != 0)
		error = sys_errlist[errno];
	sprintf(buf1, "%s: %s; (%s) %s", program, buf, error, ctime(&now));
	if ((logf = open(logfil, O_WRONLY|O_CREAT|O_APPEND, 0666)) < 0)
		return;
	(void) write(logf, buf1, strlen(buf1));
	(void) close(logf);
	errno = 0;
	va_end(list);
}
