#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/fsize.c,v 1.1 89/05/10 03:56:13 muir Exp $";
#endif

/*
 * fsize.c
 *
 * BSD dependent file and block sizing routines.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include <sys/stat.h>
#include "ship.h"
#include "plane.h"
#include "nuke.h"
#include "unit.h"

/*
 * return the size of the file in bytes.
 */
int
fsize(fd)
	int	fd;
{
	struct	stat statb;

	if (fstat(fd, &statb) < 0)
		return -1;
	return statb.st_size;
}

/*
 * return the block size of the filesystem
 * If it's not a filesystem, return 1024.
 */
int
blksize(fd)
	int	fd;
{
	struct	stat statb;

	if (fstat(fd, &statb) < 0)
		return 1024;
	return statb.st_blksize;
}
