/*
 * config.c
 *
 * parses config file keyword data item
 *
 */

#include <stdio.h>

#define CF_VALUE	1
#define CF_TIME		2
#define CF_TIMERANGE	3

char *
expect(type, text, data)
	int	type;
	char	*text;
	int	*data;
{
	char	*next;
	char	*p;
	int	hours;
	int	minutes;

	while (isspace(*text))
		text++;
	switch (type) {
	case CF_VALUE:
		*data = atoip(&text);
		break;
	case CF_TIME:
		text = get_time(text, &data[0]);
		break;
	case CF_TIMERANGE:
		if ((next = index(text, '-')) == 0)
			return 0;
		if ((text = get_time(text, &data[0])) == 0)
			return 0;
		text++;
		text = get_time(text, &data[1]);
		break;
	default:
		text = 0;
		break;
	}
	return text;
}

char *
get_time(ptr, data)
	char	*ptr;
	int	*data;
{
	char	*p;
	int	hours;
	int	minutes;

	if (!isdigit(*ptr))
		return 0;
	hours = atoip(&ptr);
	minutes = 0;
	if (*ptr) {
		if (*ptr != ':')
			return 0;
		ptr++;
		if (!isdigit(*ptr))
			return 0;
		minutes = atoip(&ptr);
	}
	*data = (hours * 60) + minutes;
	return ptr;
}
