#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/wu.c,v 1.7 89/05/10 01:46:02 muir Exp $";
#endif

/*
 * wu.c
 *
 * write a telegram to a user from another.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include <fcntl.h>
#include <sys/uio.h>
#include "nat.h"
#include "tel.h"
#include "file.h"

int
wu(from, to, buf) 
	int	from;
	int	to;
	char	*buf;
{
	return typed_wu(from, to, buf, TEL_NORM);
}

int
typed_wu(from, to, buf, type)
	int	from;
	int	to;
	char	*buf;
{
	register char *bp;
	int	len;
	struct	telstr tel;
	struct	natstr *np;
	struct	iovec iov[2];
	int	fd;

	if ((np = getnatp(to)) == 0 || (np->nat_stat & STAT_NORM) == 0)
		return 0;
	if ((fd = open(mailbox(to), O_RDWR|O_APPEND, 0)) < 0) {
		logerror("telegram 'open' to #%d failed", to);
		return 0;
	}
	tel.tel_from = from;
	(void) time(&tel.tel_date);
	bp = buf;
	while (*bp++)
		;
	len = bp - buf;
	if (len >= MAXTELSIZE)
		len = MAXTELSIZE;
	buf[len] = 0;
	tel.tel_length = len;
	tel.tel_type = type;
	iov[0].iov_base = (caddr_t) &tel;
	iov[0].iov_len = sizeof(tel);
	iov[1].iov_base = buf;
	iov[1].iov_len = len;
	if (writev(fd, iov, 2) < iov[0].iov_len + iov[1].iov_len) {
		logerror("telegram 'write' to #%d failed", to);
		return 0;
	}
	(void) close(fd);
	NAT_DELTA(nat_tgms, to, 1);
	return 0;
}
