#ifndef lint
static char *RCSid = "$Header: wethr.c 1.6 89/03/15 $";
#endif

/*
 * wethr.c
 *
 * Return barometer of a sector given the time and
 * the x,y.  If you're brave, you can "define notdef"
 * and see what breaks.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"

int	wthr_xh, wthr_yh, wthr_xl, wthr_yl;
long    wthr_date;
double  wthr_hi, wthr_lo;

#define	SECS_PER_MIN	60

/* ARGSUSED */
int
wethr(x, y, weth_hour)
	int     x;
	int     y;
	long    weth_hour;
{
#ifdef notdef
	extern	double pslsin();
	register int lodist;
	register int hidist;
	register long minute;
	register int tmp;
	register int wx;
	register int wy;
	long    now;
	double  area;
	double  dtmp;

	time(&now);
	now += hours(weth_hour);
	tmp = now - wthr_date;
	if (tmp > 300 || tmp < -300) {
		minute = now / SECS_PER_MIN;
		wthr_date = minute * SECS_PER_MIN + SECS_PER_MIN - 1;
		wx = w_xsize >> 2;
		wy = w_ysize >> 2;
		dtmp = pslsin(minute * 17);
		wthr_hi = (pslsin(minute * 19) + dtmp) * 85.+ 180.;
		dtmp = pslsin(minute * 15);
		wthr_lo = (pslsin(minute * 24) + dtmp) * 85.- 180.;
		dtmp = pslsin(minute * 14);
		tmp = (int) ((pslsin(minute * 29) + dtmp) * (double) wx);
		wthr_xh = tmp - xorg;
		dtmp = pslsin(minute * 9);
		tmp = (int) ((pslsin(minute * 28) + dtmp) * (double) wy);
		wthr_yh = tmp - yorg;
		dtmp = pslsin(minute * 13);
		tmp = (int) ((pslsin(minute * 23) + dtmp) * (double) wx);
		wthr_xl = tmp - xorg;
		dtmp = pslsin(minute * 11);
		tmp = (int) ((pslsin(minute * 26) + dtmp) * (double) wy);
		wthr_yl = tmp - yorg;
	}
	hidist = mapdist(x, y, wthr_xh, wthr_yh) + 1;
	lodist = mapdist(x, y, wthr_xl, wthr_yl) + 1;
	area = (double) w_xsize / 32.* (double) w_ysize / 32.;
	dtmp = wthr_hi / (double) hidist + wthr_lo / (double) lodist;
	return (int) (area * dtmp + 760.);
#else
	return 760;
#endif
}
