#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/trechk.c,v 1.6 89/05/10 01:45:58 muir Exp $";
#endif

/*
 * trechk.c
 *
 * Check to see if an actor has a treaty forbidding a given action,
 * and if so, see if the actor wishes to break the treaty.
 * All applicable treaties are checked.  All treaties must be broken
 * if the action is to be allowed.  Propsed treaties are warned about,
 * but no mention of broken pending treaties are made in the news.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "treaty.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"

int
trechk(actor, victim, provision)
	register int actor;
	register int victim;
	int     provision;
{
	register int i;
	char	*buf;
	int	news_verb;
	int	involved[MAXNOC];
	struct	trtstr treaty;
	time_t	now;
	int	conditions;
	int	other;
	int	broken;
	int	applied;
	struct	nstr_item nstr;

	(void) time(&now);
	broken = 0;
	applied = 0;
	for (i = 0; i < maxnoc; i++)
		involved[i] = 0;
	snxtitem_all(&nstr, EF_TREATY);
	while (nxtitem(&nstr, &treaty)) {
		if (treaty.trt_status == TS_FREE)
			continue;
		if (treaty.trt_exp < now)
			continue;
		if (actor == treaty.trt_cna) {
			conditions = treaty.trt_acond;
			other = treaty.trt_cnb;
		} else if (actor == treaty.trt_cnb) {
			conditions = treaty.trt_bcond;
			other = treaty.trt_cna;
		} else
			continue;
		if ((conditions & provision) == 0)
			continue;
		/* victim=0 for no new nukes, no enlistment, etc. */
		if (victim != other && victim != 0)
			continue;
		/* treaty applies to actor */
		applied++;
		pr(fmt("This action is in contravention of "));
		if (treaty.trt_status == TS_PROPOSED)
			pr(fmt("pending "));
		pr(fmt(" treaty #%d (with %s)\n", i, cname(victim)));
		buf = getstring("Do you wish to go ahead anyway? (yes/no) ");
		if (*buf == 'n' || *buf == 'N')
			broken = 0;
		else
			broken = 1;
		if (treaty.trt_status == TS_SIGNED)
			involved[other]++;
	}
	if (applied > 0) {
		news_verb = N_HONOR_TRE;
		if (broken > 0)
			news_verb = N_VIOL_TRE;
		for (i=0; i < maxnoc; i++)
			if (involved[i] > 0)
				nreport(actor, news_verb, i, 1);
	}
	if (applied && !broken) {
		/*
		 * if any treaty applied, and none were broken
		 * the intended action is NOT performed.
		 */
		return 0;
	}
	return 1;
}
