#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/snxtsct.c,v 1.2 89/05/10 01:45:44 muir Exp $";
#endif

/*
 * snxtsct.c
 *
 * arrange sector selection using either
 * distance or area.
 *
 * XXX we can *almost* treat sectors as items, but not quite.
 * Items are retrieved using id's, and sectors still use x,y.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"
#include "com.h"

struct	range worldrange = { 0, 0, WORLD_X, WORLD_Y, 1, 1};

/*
 * setup the nstr_sect structure for sector selection.
 * can select on either NS_ALL, NS_AREA, or NS_RANGE
 * iterate thru the "condarg" string looking
 * for arguments to compile into the nstr.
 */
int
snxtsct(np, str)
	register struct nstr_sect *np;
	char	*str;
{
	register char *cp;
	struct	range range;
	coord	cx, cy;
	int	dist;

	if (str == 0 || *str == 0) {
		if ((str = getstring("(sects)? ")) == 0)
			return 0;
	}
	switch (sarg_type(str)) {
	case NS_AREA:
		if (!sarg_area(str, &range))
			return 0;
		snxtsct_area(np, &range);
		break;
	case NS_DIST:
		if (!sarg_range(str, &cx, &cy, &dist))
			return 0;
		snxtsct_dist(np, cx, cy, dist);
		break;
	case NS_ALL:
		/* fake "all" by doing a world-sized area query */
		snxtsct_area(np, &worldrange);
		break;
	default:
		return 0;
	}
	if (condarg == 0)
		return 1;
	cp = condarg;
	while ((cp = nstr_comp(np->cond, &np->ncond, EF_SECTOR, cp)) && *cp)
		;
	if (cp == 0)
		return 0;
	return 1;
}

snxtsct_area(np, range)
	register struct nstr_sect *np;
	struct	range *range;
{
	bzero(np, sizeof(*np));
	np->range = *range;
	np->ncond = 0;
	np->type = NS_AREA;
	np->read = ef_read;
	np->x = np->range.lx - np->range.ix;
	np->y = np->range.ly;
	ef_zapcache(EF_SECTOR);
}

snxtsct_rewind(np)
	struct	nstr_sect *np;
{
	np->x = np->range.lx - np->range.ix;
	np->y = np->range.ly;
	np->id = -1;
	ef_zapcache(EF_SECTOR);
}

snxtsct_dist(np, cx, cy, dist)
	register struct nstr_sect *np;
	coord	cx, cy;
	int	dist;
{
	bzero(np, sizeof(*np));
	xydist_range(cx, cy, dist, &np->range);
	np->cx = cx;
	np->cy = cy;
	np->ncond = 0;
	np->dist = dist;
	np->type = NS_DIST;
	np->read = ef_read;
	np->x = np->range.lx - np->range.ix;
	np->y = np->range.ly;
	ef_zapcache(EF_SECTOR);
}

xydist_range(x, y, dist, rp)
	coord	x;
	coord	y;
	int	dist;
	struct	range *rp;
{
	rp->lx = xnorm((coord)(x - 2 * dist) - 1);
	rp->hx = xnorm((coord)(x + 2 * dist) + 1);
	rp->ly = ynorm((coord)(y - dist) - 1);
	rp->hy = ynorm((coord)(y + dist) + 1);
	rp->ix = 1;
	rp->iy = 1;
}
