#ifndef lint
static char *RCSid = "$Header: sect.c 1.1 89/03/15 $";
#endif

/*
 * sect.c
 *
 * post-read and pre-write sector data massage
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nat.h"
#include "deity.h"
#include "file.h"

/*ARGSUSED*/
int
sct_postread(id, ptr)
	int	id;
	char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	owner = (god || sp->sct_own == cnum);
	return 1;
}

/*ARGSUSED*/
int
sct_prewrite(id, ptr)
	int	id;
	char	*ptr;
{
	register struct sctstr *sp = (struct sctstr *) ptr;
	int	mines;

	if (sp->sct_type == SCT_BSPAN && sp->sct_effic < 20) {
		mines = getvar(V_MINE, ptr, EF_SECTOR);
		sp->sct_nv = 0;
		if (mines > 0)
			putvar(V_MINE, mines, ptr, EF_SECTOR);
		sp->sct_own = 0;
		sp->sct_oldown = 0;
		sp->sct_newtype = SCT_WATER;
		sp->sct_type = SCT_WATER;
		pr(fmt("A bridge span at %s has collapsed\n",
			xyas((int)sp->sct_x, (int)sp->sct_y, cnum)));
	}
	if (sp->sct_own != 0 && !getvar(V_CIVIL, ptr, EF_SECTOR) &&
	    !getvar(V_MILIT, ptr, EF_SECTOR)) {
		/* more cruft! */
		if (sp->sct_type == SCT_CAPIT)
			caploss(sp, (int) sp->sct_own, "");
		sp->sct_own = 0;
		sp->sct_oldown = 0;
	}
	return 1;
}
