#ifndef lint
static char *RCSid = "$Header: plane.c 1.1 89/03/15 $";
#endif

/*
 * plane.c
 *
 * plane post-read and pre-write
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "plane.h"
#include "ship.h"
#include "xy.h"
#include "file.h"
#include "nat.h"

int
pln_postread(n, ptr)
	int	n;
	char	*ptr;
{
	struct	plnstr *pp = (struct plnstr *) ptr;
	struct	shpstr theship;
	char	*p;

	if (pp->pln_ship == 0)
		return 1;
	if (!getship(pp->pln_ship, &theship) || theship.shp_effic < 20 ||
	    !(mchr[theship.shp_type].m_flags & (M_FLY|M_MSL))) {
		p = fmt("%s #%d sunk!\n", plchr[pp->pln_type].pl_name, n);
		/* yes, sunk */
		if (pp->pln_own != cnum)
			wu(0, pp->pln_own, p);
		pr(p);
		pp->pln_own = 0;
		ef_nbwrite(EF_PLANE, n, ptr);
	} else {
		/* wooof!  Carriers are a pain */
		pp->pln_x = theship.shp_x;
		pp->pln_y = theship.shp_y;
	}
	return 1;
}

/*ARGSUSED*/
int
pln_prewrite(n, ptr)
	int	n;
	char	*ptr;
{
	struct	plnstr *pp = (struct plnstr *) ptr;

	if (pp->pln_effic < 10)
		pp->pln_own = 0;
	return 1;
}
