#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/detonate.c,v 1.9 89/05/10 01:44:30 muir Exp $";
#endif

/*
 * detonate.c
 *
 * detonate a nuclear device in a sector
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "xy.h"
#include "nat.h"
#include "file.h"
#include "sect.h"
#include "nuke.h"
#include "ship.h"
#include "news.h"
#include "plane.h"
#include "nsc.h"

detonate(nuketype, x, y, airburst, bombown)
	int	nuketype;
	int	x;
	int	y;
	int	airburst;
	int	bombown;
{
	struct	nchrstr *ncp;
	struct	plnstr plane;
	struct	sctstr sect;
	struct	shpstr ship;
	char	*bp;
	char	buf[128];
	int	own;
	int	type;
	int	damage;
	int	rad;
	struct	nstr_sect ns;
	struct	nstr_item ni;

	if (airburst == 2) {
		detonate_orbit(nuketype, x, y, bombown);
		return;
	}
	ncp = &nchr[nuketype];
	kaboom(x, y, ncp->n_blast, bombown);
	rad = ncp->n_blast;
	if (!airburst)
		rad = rad * 2 / 3;
	snxtsct_dist(&ns, x, y, rad);
	while (nxtsct(&ns, &sect)) {
		own = sect.sct_own;
		type = sect.sct_type;
		if ((damage = nukedamage(ncp, ns.curdist, airburst)) <= 0)
			continue;
		if (type == SCT_SANCT) {
			pr(fmt("bounced off %s\n", xyas(ns.x, ns.y, cnum)));
			wu(0, own, fmt("%s nuclear device bounced off %s",
				cname(bombown), xyas(ns.x, ns.y, cnum)));
			nreport(bombown, N_NUKE, own, 1);
			continue;
		}
		sectdamage(&sect, damage);
		if (damage > 100) {
			sect.sct_oldown = 0;
			sect.sct_own = 0;
			if (type == SCT_WATER || type == SCT_BSPAN) {
				bp = "left nothing but water in %s\n";
				if (type != SCT_WATER) {
					sect.sct_newtype = SCT_WATER;
					sect.sct_type = SCT_WATER;
				}
			} else {
				sect.sct_newtype = SCT_WASTE;
				sect.sct_type = SCT_WASTE;
				bp = "turned %s into a radioactive wasteland\n";
			}
		} else {
			bp = buf;
			copy(fmt("did %d%%%% damage in %%s\n", damage), bp);
		}
		if (type == SCT_CAPIT && damage >= 100)
			caploss(&sect, own, "\n%s lost its capital!\n\n");
		(void) putsect(&sect);
		nreport(bombown, N_NUKE, own, 1);
		pr(fmt(bp, xyas(ns.x, ns.y, cnum)));
		if (own != cnum && own != 0) {
			(void) copy(fmt(bp, xyas(ns.x, ns.y, own)), buf);
			wu(0, own, fmt("%s nuclear device %s",
				cname(bombown), buf));
		}
	}
	snxtitem_dist(&ni, EF_SHIP, x, y, rad);
	while (nxtitem(&ni, (caddr_t)&ship)) {
		if ((own = ship.shp_own) == 0)
			continue;
		if ((damage = nukedamage(ncp, ni.curdist, airburst)) <= 0)
			continue;
		shipdamage(&ship, damage);
		if (own == cnum) {
			pr(fmt("%s #%d reports %d%% damage\n",
				mchr[ship.shp_type].m_name, ni.cur, damage));
		} else {
			wu(0, own,
			    fmt("%s nuclear device did %d%% damage to %s #%d",
				cname(bombown), damage,
				mchr[ship.shp_type].m_name, ni.cur));
		}
		putship(ni.cur, &ship);
	}
	snxtitem_dist(&ni, EF_PLANE, x, y, rad);
	while (nxtitem(&ni, (caddr_t)&plane)) {
		if ((own = plane.pln_own) == 0)
			continue;
		damage = nukedamage(ncp, ni.curdist,airburst) - plane.pln_harden;
		if (damage <= 0)
			continue;
		planedamage(&plane, damage);
		if (own == cnum) {
			pr(fmt("%s #%d reports %d%% damage\n",
				plchr[plane.pln_type].pl_name, ni.cur, damage));
		} else {
			wu(0, own,
			    fmt("%s nuclear device did %d%% damage to %s #%d",
				cname(bombown), damage,
				plchr[plane.pln_type].pl_name, ni.cur));
		}
		putplane(ni.cur, &plane);
	}
}

detonate_orbit(nuketype, x, y, bombown)
	int	nuketype;
	int	x;
	int	y;
	int	bombown;
{
	struct	nchrstr *ncp;
	struct	plnstr plane;
	struct	nstr_item ni;
	int	own;
	int	damage;
	int	rad;

	ncp = &nchr[nuketype];
	kaboom(x, y, ncp->n_blast, bombown);
	rad = ncp->n_blast;
	snxtitem_dist(&ni, EF_PLANE, x, y, rad);
	while (nxtitem(&ni, (caddr_t)&plane)) {
		if ((own = plane.pln_own) == 0)
			continue;
		if ((plane.pln_flags&PLN_LAUNCHED) == 0)
			continue;
		if ((damage = nukedamage(ncp, ni.curdist, 0)) <= 0)
			continue;
		planedamage(&plane, damage);
		if (cnum == own) {
			pr(fmt("%s #%d reports %d%% damage\n",
				plchr[plane.pln_type].pl_name, ni.cur,
				damage));
		} else {
			wu(0, own,
		    fmt("%s nuclear device did %d%% damage to %s #%d",
				cname(bombown), damage,
				plchr[plane.pln_type].pl_name, ni.cur));
		}
		nreport(bombown, N_SAT_KILL, own, 1);
		putplane(ni.cur, &plane);
	}
}

/*
 * silly to be sure.
 */
kaboom(x, y, rad, cn)
	int	x;
	int	y;
	int	rad;
	int	cn;
{
	pr("\n\nK A B ");
	while (rad-- > 0)
		pr("O O ");
	pr(fmt("M ! in %s\n\n", xyas(x, y, cn)));
}
