static char *RCSid = "$Header: weat.c,v 1.3 88/04/01 04:49:22 muir Locked $";

/*
 * $Log:	weat.c,v $
 * Revision 1.3  88/04/01  04:49:22  muir
 * rcsid now at top
 * 
 */

/*
 * weat.c
 *
 * Show the weather using map-like format
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"

void    wmap();

int
weat()
{
	extern	char *fmt();
	extern	char *argp[];
	extern  int wthr_xh, wthr_yh, wthr_xl, wthr_yl;
	register int hi;
	register int low;

	if (sargs(argp[1]) == -1)
		return RET_SYN;
	wmap(0);
	low = wethr(wthr_xl, wthr_yl, 0);
	hi = wethr(wthr_xh, wthr_yh, 0);
	pr(low < 660 ? "extreme" : (low >= 710 ? "mild" : ""));
	pr(fmt(" low pressure center at %d,%d; ", xwrap(wthr_xl),
	       ywrap(wthr_yl)));
	pr(hi > 860 ? "extreme" : (hi <= 810 ? "mild" : ""));
	pr(fmt(" high at %d,%d\n", xwrap(wthr_xh), ywrap(wthr_yh)));
	return RET_OK;
}

int
fore()
{
	extern	int god;
	extern	struct sctstr sect;
	extern	int lx, ly, hx, hy;
	extern	int ix, iy;
	extern	int owner;
	register int low;
	register int hi;
	register int hour;
	register int civilians;
	double  range;

	if (sargs(argp[1]) == -1)
		return RET_SYN;
	if (god != 0) {
		range = 99.;
	} else {
		if (getsno(argp[2], "weather station at ") == -1 || !owner) {
			pr("not yours");
			return RET_SYN;
		}
		if (sect.sct_type != SCT_WETHR) {
			pr("not a weather station, klod");
			return RET_SYN;
		}
		range = sect.sct_effic / 13.;
	}
	pr(fmt("efficiency %d%% range %.1f\n", sect.sct_effic, range));
	range *= range;
	hour = onearg(argp[3], "forecast for how many hours in the future? ");
	if (god == 0) {
		civilians = gsctv(V_CIVIL);
		if (hour > civilians) {
			pr("too small a staff to predict that far");
			return RET_FAIL;
		}
	}
	wethr(0, 0, hour);
	low = wethr(wthr_xl, wthr_yl, hour);
	hi = wethr(wthr_xh, wthr_yh, hour);
	pr(fmt("in %d hour%s there will be a", hour, splur(hour)));
	pr(fmt(low < 660 ? "n extreme" : (low >= 710 ? " mild" : "")));
	pr(fmt(" low pressure center at %d,%d and\n", wthr_xl, wthr_yl));
	pr(fmt(hi > 860 ? "an extreme" : (hi <= 810 ? "a mild" : "")));
	pr(fmt(" high at %d,%d\n", wthr_xh, wthr_yh));
	wethr(0, 0, hour + 1);
	pr(fmt("an hour later the low should be at %d,%d ", wthr_xl,
	       wthr_yl));
	pr(fmt("and the high at %d,%d\n", wthr_xh, wthr_yh));
	wmap(hour);
	return RET_OK;
}

void
wmap(hour)
	int     hour;
{
	register int pressure;
	register int y;
	register int x;

	border(lx, hx, ix, "     ", "");
	for (y = ly; y != hy; y += iy) {
		pr(fmt("%3d%s", y, ((y ^ hx) & 1) == 0 ? " " : "  "));
		for (x = lx; x != hx; x += ix) {
			if ((x ^ y) & 1)
				continue;
			pressure = wethr(x, y, hour);
			pressure = min(9, max((pressure - 766) / 12, -9));
			pr(fmt("%2d", pressure));
		}
		pr(fmt("%s%d\n", ((y ^ hx) & 1) == 0 ? "  " : " ", y));
	}
	border(lx, hx, ix, "     ", "");
}
