/*
 * wai.c
 *
 * continuously wait for telegrams; print them out when
 * you get them.
 *
 */

#include <stdio.h>
#ifdef hpux
#include <sys/types.h>
#endif
#include <sys/file.h>
#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "sailio.h"

wai()
{
	extern	int cnum;
	extern	SAIL *iop;
	extern	char *argp[];
	extern	struct natstr *natp;
	int	mask;
	int	n;

	sflush(iop);
	while (natp->nat_tgms == 0) {
		mask = (1 << 0) | (1 << iop->fd);
		n = select(32, &mask, 0, 0, 0);
		if (n < 0)
			return RET_FAIL;
		if ((1 << iop->fd) & mask)
			tm_update(iop, -1);
		if ((1 << 0) & mask)
			return RET_OK;
	}
	argp[0] = 0;
	rea();
    return RET_OK;
}
